/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bc.subtask.conversion.IssueConversionService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.bean.ConvertIssueBean;
import com.atlassian.jira.web.bean.ConvertIssueToSubTaskBean;
import com.atlassian.jira.web.session.SessionSearchObjectManagerFactory;
import com.atlassian.jira.web.session.SessionSearchRequestManager;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import webwork.action.Action;
import webwork.action.ActionContext;

public abstract class AbstractConvertIssue
extends JiraWebActionSupport {
    protected static final String SECURITY_BREACH = "securitybreach";
    private final IssueConversionService service;
    protected final IssueManager issueManager;
    protected final ConstantsManager constantsManager;
    protected final FieldLayoutManager fieldLayoutManager;
    protected final WorkflowManager workflowManager;
    protected final PermissionManager permissionManager;
    protected final RendererManager rendererManager;
    private final IssueFactory issueFactory;
    private final SessionSearchObjectManagerFactory sessionSearchObjectManagerFactory;
    protected static final int STEP_1 = 1;
    protected static final int STEP_2 = 2;
    protected static final int STEP_3 = 3;
    protected static final int STEP_4 = 4;
    protected Issue issue;
    private MutableIssue updatedIssue;
    protected String id;
    protected String issueType;
    protected String targetStatusId;
    protected String guid;
    private Collection layoutItems;
    private SearchRequest searchRequest;

    protected AbstractConvertIssue(IssueConversionService service, IssueManager issueManager, FieldLayoutManager fieldLayoutManager, ConstantsManager constantsManager, WorkflowManager workflowManager, RendererManager rendererManager, IssueFactory issueFactory, PermissionManager permissionManager) {
        this.service = service;
        this.issueManager = issueManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.constantsManager = constantsManager;
        this.workflowManager = workflowManager;
        this.rendererManager = rendererManager;
        this.issueFactory = issueFactory;
        this.permissionManager = permissionManager;
        this.sessionSearchObjectManagerFactory = (SessionSearchObjectManagerFactory)ComponentAccessor.getComponent(SessionSearchObjectManagerFactory.class);
    }

    public String doStartWizard() {
        JiraServiceContextImpl context = this.createServiceContext();
        this.initRequest((JiraServiceContext)context);
        if (context.getErrorCollection().hasAnyErrors()) {
            return "error";
        }
        if (!this.service.hasPermission((JiraServiceContext)context, this.getIssue())) {
            return SECURITY_BREACH;
        }
        this.validateIssueIsConvertable((JiraServiceContext)context);
        if (context.getErrorCollection().hasAnyErrors()) {
            return "error";
        }
        this.setCurrentStep(1);
        return "success";
    }

    public String doSetIssueType() {
        JiraServiceContextImpl context = this.createServiceContext();
        ConvertIssueBean bean = this.getBean();
        this.setCurrentStep(1);
        this.initRequest((JiraServiceContext)context);
        if (context.getErrorCollection().hasAnyErrors()) {
            return "error";
        }
        if (!this.service.hasPermission((JiraServiceContext)context, this.getIssue())) {
            return SECURITY_BREACH;
        }
        this.validateIssueIsConvertable((JiraServiceContext)context);
        this.validateStep1(context);
        if (context.getErrorCollection().hasAnyErrors()) {
            return "error";
        }
        if (this.isStatusChangeRequired()) {
            this.setCurrentStep(2);
            return "success_updateworkflow";
        }
        bean.setTargetStatusId(this.getIssue().getStatusObject().getId());
        this.populateDefaultFieldValues();
        if (context.getErrorCollection().hasAnyErrors()) {
            return "error";
        }
        this.setCurrentStep(3);
        return "success_updatefields";
    }

    public String doSetWorkflowStatus() {
        JiraServiceContextImpl context = this.createServiceContext();
        this.setCurrentStep(2);
        this.initRequest((JiraServiceContext)context);
        if (context.getErrorCollection().hasAnyErrors()) {
            return "error";
        }
        if (!this.service.hasPermission((JiraServiceContext)context, this.getIssue())) {
            return SECURITY_BREACH;
        }
        this.validateIssueIsConvertable((JiraServiceContext)context);
        this.validateStep1(context);
        this.validateWorkflowStatus((JiraServiceContext)context);
        if (context.getErrorCollection().hasAnyErrors()) {
            return "error";
        }
        this.populateDefaultFieldValues();
        if (context.getErrorCollection().hasAnyErrors()) {
            return "error";
        }
        this.setCurrentStep(3);
        return "success";
    }

    public String doUpdateFields() {
        JiraServiceContextImpl context = this.createServiceContext();
        this.getBean().setCurrentStep(3);
        this.initRequest((JiraServiceContext)context);
        if (context.getErrorCollection().hasAnyErrors()) {
            return "error";
        }
        if (!this.service.hasPermission((JiraServiceContext)context, this.getIssue())) {
            return SECURITY_BREACH;
        }
        this.validateIssueIsConvertable((JiraServiceContext)context);
        this.validateStep1(context);
        this.validateWorkflowStatus((JiraServiceContext)context);
        if (context.getErrorCollection().hasAnyErrors()) {
            return "error";
        }
        this.service.populateFields((JiraServiceContext)context, (OperationContext)this.getBean(), (I18nHelper)this, (Issue)this.getTargetIssue(), this.getConvertFieldLayoutItems());
        if (context.getErrorCollection().hasAnyErrors()) {
            return "error";
        }
        this.setCurrentStep(4);
        return "success";
    }

    @RequiresXsrfCheck
    public String doConvert() {
        JiraServiceContextImpl context = this.createServiceContext();
        this.initRequest((JiraServiceContext)context);
        if (context.getErrorCollection().hasAnyErrors()) {
            return "error";
        }
        if (!this.service.hasPermission((JiraServiceContext)context, this.getIssue())) {
            return SECURITY_BREACH;
        }
        this.validateIssueIsConvertable((JiraServiceContext)context);
        this.validateStep1(context);
        this.validateWorkflowStatus((JiraServiceContext)context);
        this.service.validateFields((JiraServiceContext)context, (OperationContext)this.getBean(), (I18nHelper)this, (Issue)this.getTargetIssue(), this.getConvertFieldLayoutItems());
        if (context.getErrorCollection().hasAnyErrors()) {
            return "error";
        }
        this.service.convertIssue((JiraServiceContext)context, this.getIssue(), this.getUpdatedIssue());
        if (context.getErrorCollection().hasAnyErrors()) {
            return "error";
        }
        String key = this.getIssue().getKey();
        this.getBean().clearSession(this.request.getSession());
        if (this.permissionManager.hasPermission(10, this.getIssue(), context.getLoggedInUser())) {
            return this.getRedirect("/browse/" + key);
        }
        return this.getRedirect("CantBrowseCreatedIssue.jspa?issueKey=" + key + "&converted=true");
    }

    public String doCancel() {
        Issue issue = this.getIssue();
        ConvertIssueBean bean = this.getBean();
        if (issue == null) {
            bean.clearSession(this.request.getSession());
            this.log.error((Object)("Could not retrieve issue for id:" + this.getId()));
            return this.getRedirect("/");
        }
        String key = issue.getKey();
        bean.clearSession(this.request.getSession());
        return this.getRedirect("/browse/" + key);
    }

    protected void initRequest(JiraServiceContext context) {
        ConvertIssueBean bean = this.getBean();
        Issue issue = this.getIssue();
        if (issue == null) {
            this.addI18nErrorMessage(context, "convert.issue.to.subtask.error.nosuchissue", this.getId());
            return;
        }
        if (TextUtils.stringSet((String)this.guid) && bean.getVersion() == null) {
            this.addI18nErrorMessage(context, "convert.issue.to.subtask.errormessage.sessiontimeout");
            return;
        }
        if (TextUtils.stringSet((String)this.guid) && !this.guid.equals(bean.getVersion())) {
            this.addI18nErrorMessage(context, "convert.issue.to.subtask.errormessage.invalidstate", issue.getKey());
            return;
        }
        if (!this.wasPassed("guid")) {
            bean.clearBean();
            bean.generateNextVersion();
        }
        if (this.wasPassed("issuetype")) {
            bean.setIssueType(this.issueType);
        }
        if (this.wasPassed("targetStatusId")) {
            bean.setTargetStatusId(this.targetStatusId);
        }
        this.initExtraFields(bean, context);
    }

    private boolean validateIssueIsConvertable(JiraServiceContext context) {
        return this.service.canConvertIssue(context, this.getIssue());
    }

    private void validateIssueType(JiraServiceContext context) {
        String issueTypeId = this.getIssuetype();
        if (!TextUtils.stringSet((String)issueTypeId)) {
            this.addI18nError(context, "issuetype", "convert.issue.to.subtask.error.noissuetype");
            return;
        }
        IssueType issueTypeObject = this.constantsManager.getIssueTypeObject(issueTypeId);
        if (issueTypeObject == null) {
            this.addI18nError(context, "issuetype", "convert.issue.to.subtask.error.nosuchissuetype");
            return;
        }
        this.service.validateTargetIssueType(context, this.getIssue(), issueTypeObject, "issuetype");
    }

    private void validateWorkflowStatus(JiraServiceContext context) {
        String fieldName = "targetStatusId";
        String targetStatusId = this.getTargetStatusId();
        if (!TextUtils.stringSet((String)targetStatusId)) {
            this.addI18nError(context, "targetStatusId", "convert.issue.to.subtask.error.statusnotgiven", targetStatusId);
            return;
        }
        Status status = this.constantsManager.getStatusObject(targetStatusId);
        IssueType subTaskType = this.constantsManager.getIssueTypeObject(this.getBean().getIssueType());
        if (status == null) {
            this.addI18nError(context, "targetStatusId", "convert.issue.to.subtask.error.statusdoesnotexist", targetStatusId);
            return;
        }
        this.service.validateTargetStatus(context, status, "targetStatusId", this.getIssue(), subTaskType);
    }

    protected void validateStep1(JiraServiceContextImpl context) {
        this.validateIssueType((JiraServiceContext)context);
    }

    public Issue getIssue() {
        if (this.issue == null) {
            Long id;
            try {
                id = Long.valueOf(this.getId());
            }
            catch (NumberFormatException e) {
                id = null;
            }
            if (id != null) {
                this.issue = this.issueManager.getIssueObject(id);
            }
        }
        return this.issue;
    }

    private JiraServiceContextImpl createServiceContext() {
        return new JiraServiceContextImpl(this.getLoggedInUser(), (ErrorCollection)this);
    }

    protected boolean wasPassed(String param) {
        return ActionContext.getParameters().containsKey(param);
    }

    protected ConvertIssueBean getBean() {
        return ConvertIssueBean.getBean(this.request.getSession(), this.getId());
    }

    private void populateDefaultFieldValues() {
        MutableIssue targetIssue = this.getTargetIssue();
        Issue origIssue = this.getIssue();
        Collection fieldItems = this.service.getFieldLayoutItems(origIssue, (Issue)targetIssue);
        for (Object fieldItem : fieldItems) {
            FieldLayoutItem item = (FieldLayoutItem)fieldItem;
            OrderableField orderableField = item.getOrderableField();
            if (!orderableField.isShown((Issue)targetIssue)) continue;
            orderableField.populateForMove(this.getBean().getFieldValuesHolder(), origIssue, (Issue)targetIssue);
        }
    }

    public MutableIssue getTargetIssue() {
        OrderableField orderableField;
        MutableIssue targetIssue = this.getTargetIssueObjectWithSecurityLevel();
        FieldLayout layout = this.fieldLayoutManager.getFieldLayout(this.getIssue());
        FieldLayoutItem fieldLayoutItem = layout.getFieldLayoutItem("security");
        if (fieldLayoutItem != null && (orderableField = fieldLayoutItem.getOrderableField()).needsMove((Collection)EasyList.build((Object)this.getIssue()), (Issue)targetIssue, fieldLayoutItem).getResult()) {
            targetIssue.setSecurityLevel(null);
        }
        return targetIssue;
    }

    protected MutableIssue getTargetIssueObjectWithSecurityLevel() {
        ConvertIssueBean bean = this.getBean();
        MutableIssue targetIssue = this.issueManager.getIssueObject(this.getIssue().getId());
        targetIssue = this.issueFactory.cloneIssueNoParent((Issue)targetIssue);
        targetIssue.setIssueTypeId(bean.getIssueType());
        if (bean.getTargetStatusId() != null) {
            targetIssue.setStatusId(bean.getTargetStatusId());
        }
        return targetIssue;
    }

    public boolean isStatusChangeRequired() {
        Issue issue = this.getIssue();
        JiraServiceContextImpl context = this.createServiceContext();
        IssueType subTaskType = this.constantsManager.getIssueTypeObject(this.getBean().getIssueType());
        return this.service.isStatusChangeRequired((JiraServiceContext)context, issue, subTaskType);
    }

    public MutableIssue getUpdatedIssue() {
        if (this.updatedIssue == null) {
            MutableIssue targetIssue = this.getTargetIssueObjectWithSecurityLevel();
            Iterator<FieldLayoutItem> i$ = this.getConvertFieldLayoutItems().iterator();
            while (i$.hasNext()) {
                FieldLayoutItem o;
                FieldLayoutItem fieldLayoutItem = o = i$.next();
                OrderableField orderableField = fieldLayoutItem.getOrderableField();
                orderableField.updateIssue(fieldLayoutItem, targetIssue, this.getBean().getFieldValuesHolder());
            }
            Collection removedFields = this.getRemoveFields();
            for (Object removedField : removedFields) {
                OrderableField field = (OrderableField)removedField;
                field.removeValueFromIssueObject(targetIssue);
            }
            this.updatedIssue = targetIssue;
        }
        return this.updatedIssue;
    }

    public Collection<FieldLayoutItem> getConvertFieldLayoutItems() {
        if (this.layoutItems == null) {
            this.layoutItems = this.service.getFieldLayoutItems(this.getIssue(), (Issue)this.getTargetIssue());
        }
        return this.layoutItems;
    }

    public Collection getRemoveFields() {
        return this.service.getRemovedFields(this.getIssue(), (Issue)this.getTargetIssue());
    }

    public JiraWorkflow getTargetWorkflow() {
        Long projectId = this.getIssue().getProjectObject().getId();
        String issueTypeId = this.getBean().getIssueType();
        try {
            return this.workflowManager.getWorkflow(projectId, issueTypeId);
        }
        catch (WorkflowException e) {
            String msg = "Failed retrieving workflow for project: " + projectId + " and issue type:" + issueTypeId;
            this.log.error((Object)msg, (Throwable)e);
            throw new DataAccessException(msg, (Throwable)e);
        }
    }

    public String getFieldName(Field field) {
        if (field instanceof CustomField) {
            return field.getName();
        }
        return this.getText(field.getNameKey());
    }

    public String getOldViewHtml(OrderableField field) {
        FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(this.getIssue());
        FieldLayoutItem fieldLayoutItem = fieldLayout.getFieldLayoutItem(field);
        Map displayParams = MapBuilder.newBuilder((Object)"readonly", (Object)Boolean.TRUE).add((Object)"nolink", (Object)Boolean.TRUE).add((Object)"prefix", (Object)"old_").toMutableMap();
        return field.getViewHtml(fieldLayoutItem, (Action)this, this.getIssue(), displayParams);
    }

    public String getNewViewHtml(OrderableField field) {
        String html;
        MutableIssue updatedIssue = this.getUpdatedIssue();
        FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout((Issue)updatedIssue);
        FieldLayoutItem fieldLayoutItem = fieldLayout.getFieldLayoutItem(field);
        if (field instanceof CustomField && ((CustomField)field).isRenderable()) {
            IssueRenderContext renderContext;
            String unrenderedValue;
            String rendererType = fieldLayoutItem.getRendererType();
            html = this.rendererManager.getRenderedContent(rendererType, unrenderedValue = (String)updatedIssue.getCustomFieldValue((CustomField)field), renderContext = updatedIssue.getIssueRenderContext());
            if (html == null || "".equals(html.trim())) {
                html = "&nbsp;";
            }
        } else {
            Map displayParams = MapBuilder.newBuilder((Object)"readonly", (Object)Boolean.TRUE).add((Object)"nolink", (Object)Boolean.TRUE).add((Object)"prefix", (Object)"new_").toMutableMap();
            html = field.getViewHtml(fieldLayoutItem, (Action)this, (Issue)updatedIssue, displayParams);
        }
        return html;
    }

    public String getFieldHtml(FieldLayoutItem fieldLayoutItem) {
        MutableIssue targetIssue;
        OrderableField orderableField = fieldLayoutItem.getOrderableField();
        if (orderableField.isShown((Issue)(targetIssue = this.getTargetIssue()))) {
            return orderableField.getCreateHtml(fieldLayoutItem, (OperationContext)this.getBean(), (Action)this, (Issue)targetIssue);
        }
        return "";
    }

    public JiraWorkflow getCurrentWorkflow() {
        Issue issue = this.getIssue();
        try {
            return this.workflowManager.getWorkflow(issue);
        }
        catch (WorkflowException e) {
            String msg = "Failed retrieving workflow for issue: " + issue.getKey();
            this.log.error((Object)msg, (Throwable)e);
            throw new DataAccessException(msg, (Throwable)e);
        }
    }

    public SearchRequest getSearchRequest() {
        if (this.searchRequest == null) {
            this.searchRequest = this.getSearchRequestFromSession();
        }
        return this.searchRequest;
    }

    private SearchRequest getSearchRequestFromSession() {
        SessionSearchRequestManager sessionSearchRequestManager = this.sessionSearchObjectManagerFactory.createSearchRequestManager();
        return (SearchRequest)sessionSearchRequestManager.getCurrentObject();
    }

    public String getCurrentJQL() {
        SearchRequest sr = this.getSearchRequest();
        if (sr != null) {
            SearchService searchService = ComponentManager.getInstance().getSearchService();
            return searchService.getJqlString(sr.getQuery());
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getParentIssueKey() {
        return ((ConvertIssueToSubTaskBean)this.getBean()).getParentIssueKey();
    }

    public String getTargetStatusId() {
        return this.getBean().getTargetStatusId();
    }

    public void setTargetStatusId(String targetStatusId) {
        this.targetStatusId = targetStatusId;
    }

    public String getIssuetype() {
        return this.getBean().getIssueType();
    }

    public void setIssuetype(String subTaskType) {
        this.issueType = subTaskType;
    }

    public String getGuid() {
        return this.getBean().getVersion();
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public int getCurrentStep() {
        return this.getBean().getCurrentStep();
    }

    protected void setCurrentStep(int step) {
        this.getBean().setCurrentStep(step);
    }

    protected void addI18nErrorMessage(JiraServiceContext context, String i18nKey) {
        context.getErrorCollection().addErrorMessage(this.getText(i18nKey));
    }

    protected void addI18nErrorMessage(JiraServiceContext context, String i18nKey, String param) {
        context.getErrorCollection().addErrorMessage(this.getText(i18nKey, param));
    }

    protected void addI18nError(JiraServiceContext context, String fieldName, String i18nKey) {
        context.getErrorCollection().addError(fieldName, this.getText(i18nKey));
    }

    protected void addI18nError(JiraServiceContext context, String fieldName, String i18nKey, String param) {
        context.getErrorCollection().addError(fieldName, this.getText(i18nKey, param));
    }

    public String getTextKey(String key) {
        return this.getPropertiesPrefix() + "." + key;
    }

    public String getIssuePath() {
        MutableIssue targetIssue = this.issueManager.getIssueObject(this.getIssue().getId());
        targetIssue = this.issueFactory.cloneIssueNoParent((Issue)targetIssue);
        return "/browse/" + targetIssue.getKey();
    }

    public abstract String getActionPrefix();

    public abstract String getPropertiesPrefix();

    public abstract Collection getAvailableIssueTypes();

    protected abstract void initExtraFields(ConvertIssueBean var1, JiraServiceContext var2);
}

