/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.filter;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.bc.filter.FilterSubscriptionService;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.web.action.filter.AbstractFilterAction;
import java.util.Collection;

public class DeleteFilter
extends AbstractFilterAction {
    private final SearchRequestService searchRequestService;
    private final FilterSubscriptionService subscriptionService;
    private final FavouritesService favouriteService;
    private Long otherFavouriteCount;
    private Collection subscriptions;

    public DeleteFilter(IssueSearcherManager issueSearcherManager, SearchRequestService searchRequestService, FavouritesService favouriteService, SearchService searchService, SearchSortUtil searchSortUtil, FilterSubscriptionService subscriptionService) {
        super(issueSearcherManager, searchService, searchSortUtil);
        this.searchRequestService = searchRequestService;
        this.favouriteService = favouriteService;
        this.subscriptionService = subscriptionService;
    }

    public int getOtherFavouriteCount() {
        if (this.otherFavouriteCount == null) {
            SearchRequest request = this.getFilter();
            boolean isFavourite = this.favouriteService.isFavourite(this.getLoggedInApplicationUser(), (SharedEntity)request);
            int count = isFavourite ? request.getFavouriteCount().intValue() - 1 : request.getFavouriteCount().intValue();
            this.otherFavouriteCount = count;
        }
        return this.otherFavouriteCount.intValue();
    }

    public boolean canDelete() {
        return !this.hasAnyErrors();
    }

    public int getSubscriptionCount() {
        return this.getSubscriptions().size();
    }

    public Collection getSubscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = this.subscriptionService.getVisibleSubscriptions(this.getLoggedInApplicationUser(), this.getFilter());
        }
        return this.subscriptions;
    }

    public boolean isUserLoggedIn() {
        return this.getLoggedInUser() != null;
    }

    public String doDefault() throws Exception {
        JiraServiceContext ctx = this.getJiraServiceContext();
        if (this.getFilterId() != null) {
            this.searchRequestService.validateForDelete(ctx, this.getFilterId());
            if (this.hasAnyErrors()) {
                return "error";
            }
        } else {
            this.addErrorMessage(this.getText("admin.errors.filters.cannot.delete.filter"));
            return "error";
        }
        return "input";
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        JiraServiceContext ctx = this.getJiraServiceContext();
        if (this.getFilterId() != null) {
            this.searchRequestService.validateForDelete(ctx, this.getFilterId());
            if (this.hasAnyErrors()) {
                return "error";
            }
            this.searchRequestService.deleteFilter(ctx, this.getFilterId());
            if (this.hasAnyErrors()) {
                return "error";
            }
        } else {
            this.addErrorMessage(this.getText("admin.errors.filters.cannot.delete.filter"));
            return "error";
        }
        this.setSearchRequest(null);
        return this.returnComplete(this.getReturnUrl());
    }
}

