/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.CollectionReorderer;
import com.atlassian.jira.web.action.admin.workflow.AbstractWorkflowTransitionAction;
import com.atlassian.jira.web.action.util.workflow.WorkflowEditorTransitionConditionUtil;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowActionsBean;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import com.opensymphony.workflow.loader.ConditionalResultDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.RestrictionDescriptor;
import com.opensymphony.workflow.loader.ResultDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.Collection;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

@WebSudoRequired
public class ViewWorkflowTransition
extends AbstractWorkflowTransitionAction {
    public static final String DESCRIPTOR_TAB_ALL = "all";
    public static final String DESCRIPTOR_TAB_CONDITIONS = "conditions";
    public static final String DESCRIPTOR_TAB_VALIDATORS = "validators";
    public static final String DESCRIPTOR_TAB_POST_FUNCTIONS = "postfunctions";
    public static final String DESCRIPTOR_TAB_OTHER = "other";
    public static final String DESCRIPTOR_TAB_DEFAULT = "conditions";
    private final ConstantsManager constantsManager;
    private final CollectionReorderer collectionReorderer;
    private final WorkflowActionsBean workflowActionsBean;
    private int up;
    private int down;
    private String count;
    private String currentCount;
    private String descriptorTab;

    public ViewWorkflowTransition(JiraWorkflow workflow, StepDescriptor step, ActionDescriptor transition, PluginAccessor pluginAccessor, ConstantsManager constantsManager, CollectionReorderer collectionReorderer, WorkflowService workflowService) {
        super(workflow, step, transition, pluginAccessor, workflowService);
        this.constantsManager = constantsManager;
        this.collectionReorderer = collectionReorderer;
        this.workflowActionsBean = new WorkflowActionsBean();
    }

    public ViewWorkflowTransition(JiraWorkflow workflow, ActionDescriptor transition, PluginAccessor pluginAccessor, ConstantsManager constantsManager, CollectionReorderer collectionReorderer, WorkflowService workflowService) {
        super(workflow, transition, pluginAccessor, workflowService);
        this.constantsManager = constantsManager;
        this.collectionReorderer = collectionReorderer;
        this.workflowActionsBean = new WorkflowActionsBean();
    }

    public StepDescriptor getStepDescriptor(ConditionalResultDescriptor conditionalResultDescriptor) {
        int targetStepId = conditionalResultDescriptor.getStep();
        return this.getWorkflow().getDescriptor().getStep(targetStepId);
    }

    public GenericValue getStatus(String id) {
        return this.constantsManager.getStatus(id);
    }

    public Status getStatusObject(String id) {
        return this.constantsManager.getStatusObject(id);
    }

    @RequiresXsrfCheck
    public String doMoveWorkflowFunctionUp() throws Exception {
        List postFunctions = this.getTransition().getUnconditionalResult().getPostFunctions();
        if (this.up <= 0 || this.up >= postFunctions.size()) {
            this.addErrorMessage(this.getText("admin.errors.workflows.invalid.index", "" + this.up));
        } else {
            Object toMove = postFunctions.get(this.up);
            this.collectionReorderer.increasePosition(postFunctions, toMove);
            this.workflowService.updateWorkflow(this.getJiraServiceContext(), this.getWorkflow());
        }
        return this.getViewRedirect("&currentCount=workflow-function" + this.up);
    }

    @RequiresXsrfCheck
    public String doMoveWorkflowFunctionDown() throws Exception {
        List postFunctions = this.getTransition().getUnconditionalResult().getPostFunctions();
        if (this.down < 0 || this.down >= postFunctions.size() - 1) {
            this.addErrorMessage(this.getText("admin.errors.workflows.invalid.index", "" + this.down));
        } else {
            Object toMove = postFunctions.get(this.down);
            this.collectionReorderer.decreasePosition(postFunctions, toMove);
            this.workflowService.updateWorkflow(this.getJiraServiceContext(), this.getWorkflow());
        }
        return this.getViewRedirect("&currentCount=workflow-function" + (this.down + 2));
    }

    @RequiresXsrfCheck
    public String doChangeLogicOperator() throws Exception {
        WorkflowEditorTransitionConditionUtil wetcu = new WorkflowEditorTransitionConditionUtil();
        wetcu.changeLogicOperator(this.getTransition(), this.getCount());
        this.workflowService.updateWorkflow(this.getJiraServiceContext(), this.getWorkflow());
        return this.getViewRedirect("");
    }

    protected String getViewRedirect(String postfix) {
        if (this.getStep() == null) {
            return this.getRedirect("ViewWorkflowTransition.jspa" + this.getBasicWorkflowParameters() + "&workflowTransition=" + this.getTransition().getId() + postfix);
        }
        return this.getRedirect("ViewWorkflowTransition.jspa" + this.getBasicWorkflowParameters() + "&workflowStep=" + this.getStep().getId() + "&workflowTransition=" + this.getTransition().getId() + postfix);
    }

    public int getUp() {
        return this.up;
    }

    public void setUp(int up) {
        this.up = up;
    }

    public int getDown() {
        return this.down;
    }

    public void setDown(int down) {
        this.down = down;
    }

    public Collection getStepsForTransition() {
        return this.getWorkflow().getStepsForTransition(this.getTransition());
    }

    public boolean isInitial() {
        return this.getWorkflow().isInitialAction(this.getTransition());
    }

    public boolean isGlobal() {
        return this.getWorkflow().isGlobalAction(this.getTransition());
    }

    public boolean isCommon() {
        return this.getWorkflow().isCommonAction(this.getTransition());
    }

    public boolean isTransitionWithoutStepChange() {
        return this.getTransition().getUnconditionalResult().getStep() == -1;
    }

    public String getDescriptorTab() {
        if (!TextUtils.stringSet((String)this.descriptorTab)) {
            this.descriptorTab = (String)ActionContext.getSession().get("jira.wf.editor.transition.tab.selected");
            if (!TextUtils.stringSet((String)this.descriptorTab)) {
                this.descriptorTab = "conditions";
            }
            if (this.isInitial() && "conditions".equals(this.descriptorTab)) {
                this.descriptorTab = DESCRIPTOR_TAB_VALIDATORS;
            }
        }
        if (DESCRIPTOR_TAB_OTHER.equals(this.descriptorTab) && !this.isShowOtherTab()) {
            this.descriptorTab = "conditions";
        }
        return this.descriptorTab;
    }

    public void setDescriptorTab(String descriptorTab) {
        if (TextUtils.stringSet((String)descriptorTab)) {
            ActionContext.getSession().put("jira.wf.editor.transition.tab.selected", descriptorTab);
        }
        this.descriptorTab = descriptorTab;
    }

    public int getNumberConditions() {
        RestrictionDescriptor restriction = this.getTransition().getRestriction();
        if (restriction != null) {
            return this.getNumberConditions(restriction.getConditionsDescriptor());
        }
        return 0;
    }

    private int getNumberConditions(ConditionsDescriptor conditionsDescriptor) {
        List conditions;
        int number = 0;
        if (conditionsDescriptor != null && (conditions = conditionsDescriptor.getConditions()) != null) {
            for (Object o : conditions) {
                if (o instanceof ConditionDescriptor) {
                    ++number;
                    continue;
                }
                if (o instanceof ConditionsDescriptor) {
                    number += this.getNumberConditions((ConditionsDescriptor)o);
                    continue;
                }
                throw new IllegalArgumentException("Invalid object " + o + " found in condition collection.");
            }
        }
        return number;
    }

    public boolean isShowOtherTab() {
        if (this.getTransition().getConditionalResults() != null && !this.getTransition().getConditionalResults().isEmpty()) {
            return true;
        }
        ResultDescriptor unconditionalResult = this.getTransition().getUnconditionalResult();
        if (unconditionalResult != null) {
            if (unconditionalResult.getValidators() != null && !unconditionalResult.getValidators().isEmpty()) {
                return true;
            }
            if (unconditionalResult.getPreFunctions() != null && !unconditionalResult.getPreFunctions().isEmpty()) {
                return true;
            }
        }
        if (this.getTransition().getPreFunctions() != null && !this.getTransition().getPreFunctions().isEmpty()) {
            return true;
        }
        return this.getTransition().getPostFunctions() != null && !this.getTransition().getPostFunctions().isEmpty();
    }

    public FieldScreen getFieldScreen() {
        return this.workflowActionsBean.getFieldScreenForView(this.getTransition());
    }

    public String getCount() {
        return this.count;
    }

    public void setCount(String count) {
        this.count = count;
    }

    public String getCurrentCount() {
        return this.currentCount;
    }

    public void setCurrentCount(String currentCount) {
        this.currentCount = currentCount;
    }
}

