/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.web.action.admin.workflow.AbstractWorkflowAction;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import org.ofbiz.core.entity.GenericValue;

public class AbstractWorkflowStep
extends AbstractWorkflowAction {
    protected final ConstantsManager constantsManager;
    private String stepName;
    private String stepStatus;
    protected final WorkflowService workflowService;

    public AbstractWorkflowStep(JiraWorkflow workflow, ConstantsManager constantsManager, WorkflowService workflowService) {
        super(workflow);
        this.constantsManager = constantsManager;
        this.workflowService = workflowService;
    }

    public String getStepName() {
        return this.stepName;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    public Collection getUnlinkedStatusesGVs() {
        return this.getUnlinkedStatuses(true);
    }

    public Collection getUnlinkedStatuses() {
        return this.getUnlinkedStatuses(false);
    }

    public Collection getUnlinkedStatuses(boolean genericValues) {
        Collection statuses = this.constantsManager.getStatusObjects();
        ArrayList<Object> unlinkedStatuses = new ArrayList<Object>(statuses.size());
        for (Status status : statuses) {
            GenericValue statusGV = status.getGenericValue();
            if (this.isStatusLinked(statusGV)) continue;
            if (genericValues) {
                unlinkedStatuses.add(statusGV);
                continue;
            }
            unlinkedStatuses.add(status);
        }
        return unlinkedStatuses;
    }

    private boolean isStatusLinked(GenericValue status) {
        for (Object o : this.workflow.getDescriptor().getSteps()) {
            StepDescriptor stepDescriptor = (StepDescriptor)o;
            if (!status.getString("id").equals(stepDescriptor.getMetaAttributes().get("jira.status.id"))) continue;
            return true;
        }
        return false;
    }

    public String getStepStatus() {
        return this.stepStatus;
    }

    public void setStepStatus(String stepStatus) {
        this.stepStatus = stepStatus;
    }

    @Override
    public JiraWorkflow getWorkflow() {
        return this.workflow;
    }

    public ConstantsManager getConstantsManager() {
        return this.constantsManager;
    }

    public boolean isOldStepOnDraft(StepDescriptor stepDescriptor) {
        if (!this.workflow.isDraftWorkflow()) {
            return false;
        }
        JiraWorkflow jiraWorkflow = this.workflowService.getWorkflow(this.getJiraServiceContext(), this.workflow.getName());
        return jiraWorkflow.getDescriptor().getStep(stepDescriptor.getId()) != null;
    }

    public boolean isCanDeleteStep(StepDescriptor stepDescriptor) throws WorkflowException {
        if (!this.workflow.isEditable()) {
            return false;
        }
        return this.workflow.getActionsWithResult(stepDescriptor).isEmpty() && !this.isOldStepOnDraft(stepDescriptor);
    }

    public boolean isStepWithoutTransitionsOnDraft(int stepId) {
        return this.workflowService.isStepOnDraftWithNoTransitionsOnParentWorkflow(this.getJiraServiceContext(), this.getWorkflow(), stepId);
    }
}

