/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.UserFilterManager;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.web.action.AbstractBrowser;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.bean.UserPickerFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import webwork.action.ActionContext;
import webwork.util.BeanUtil;

public class UserPickerBrowser
extends AbstractBrowser {
    private List<User> users;
    private String formName;
    private String element;
    public static final int ALL_USERS = 1;
    public static final int ASSIGNABLE = 2;
    private boolean multiSelect = false;
    private final EmailFormatter emailFormatter;
    private final FieldConfigManager fieldConfigManager;
    private final GroupManager groupManager;
    private final PermissionManager permissionManager;
    private final UserFilterManager userFilterManager;
    private final UserPickerSearchService userPickerSearchService;
    private List<String> previouslySelectedUsers = new ArrayList<String>();
    private Long fieldConfigId;

    public UserPickerBrowser(EmailFormatter emailFormatter, FieldConfigManager fieldConfigManager, GroupManager groupManager, PermissionManager permissionManager, UserFilterManager userFilterManager, UserPickerSearchService userPickerSearchService) {
        this.emailFormatter = emailFormatter;
        this.fieldConfigManager = fieldConfigManager;
        this.groupManager = groupManager;
        this.permissionManager = permissionManager;
        this.userFilterManager = userFilterManager;
        this.userPickerSearchService = userPickerSearchService;
    }

    protected String doExecute() throws Exception {
        this.resetPager();
        BeanUtil.setProperties((Map)this.params, (Object)((Object)this.getFilter()));
        if ((this.params.containsKey("emailFilter") || this.params.containsKey("group") || this.params.containsKey("nameFilter")) && !this.params.containsKey("start")) {
            this.setStart("0");
        }
        if (this.getBrowsableItems().size() <= this.getPager().getStart()) {
            this.setStart("0");
        }
        return super.doExecute();
    }

    @Override
    public PagerFilter getPager() {
        return this.getFilter();
    }

    @Override
    public void resetPager() {
        ActionContext.getSession().put("jira.userpicker.filter", null);
    }

    public UserPickerFilter getFilter() {
        UserPickerFilter filter = (UserPickerFilter)((Object)ActionContext.getSession().get("jira.userpicker.filter"));
        if (filter == null) {
            filter = new UserPickerFilter(this.fieldConfigManager, this.getJiraServiceContext(), this.permissionManager, this.userFilterManager, this.userPickerSearchService);
            ActionContext.getSession().put("jira.userpicker.filter", filter);
        }
        return filter;
    }

    @Override
    public List getCurrentPage() {
        return this.getFilter().getCurrentPage(this.getBrowsableItems());
    }

    @Override
    public List getBrowsableItems() {
        if (this.users == null) {
            try {
                this.users = this.getFilter().getFilteredUsers();
            }
            catch (Exception e) {
                this.log.error((Object)("Exception getting users: " + e), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.users;
    }

    public Collection getGroups() {
        return this.groupManager.getAllGroups();
    }

    public Collection getUsers() {
        return this.getBrowsableItems();
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public String getElement() {
        return this.element;
    }

    public void setElement(String element) {
        this.element = element;
    }

    public boolean getPermission() {
        return this.hasPermission(27);
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public void setMultiSelect(boolean isMultiSelect) {
        this.multiSelect = isMultiSelect;
    }

    public boolean getEmailColumnVisible() {
        return this.emailFormatter.emailVisible(this.getLoggedInUser());
    }

    public String getDisplayEmail(String email) {
        return this.emailFormatter.formatEmail(email, this.getLoggedInUser());
    }

    public String getPreviouslySelected() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.previouslySelectedUsers.isEmpty()) {
            stringBuilder.append(";");
        }
        for (String userName : this.previouslySelectedUsers) {
            stringBuilder.append(this.encode(userName));
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    public void setPreviouslySelected(String previouslySelected) {
        if (previouslySelected.length() != 0) {
            String[] users;
            previouslySelected = previouslySelected.substring(1, previouslySelected.length() - 1);
            for (String user : users = previouslySelected.split(";")) {
                this.previouslySelectedUsers.add(this.decode(user));
            }
        }
    }

    public boolean wasPreviouslySelected(User user) {
        return this.previouslySelectedUsers.contains(user.getName());
    }

    public Long getFieldConfigId() {
        return this.fieldConfigId;
    }

    public void setFieldConfigId(Long fieldConfigId) {
        this.fieldConfigId = fieldConfigId;
    }

    public Collection<Long> getProjectIds() {
        return this.getFilter().getProjectIds();
    }

    private String decode(String user) {
        return user.replace("%59", ";");
    }

    private String encode(String user) {
        return user.replace(";", "%59");
    }
}

