/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.plugin.user.PreDeleteUserErrorsManager;
import com.atlassian.jira.plugin.user.WebErrorMessage;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserDeleteVeto;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.BaseUrl;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.web.action.admin.user.ViewUser;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DeleteUser
extends ViewUser {
    private final SearchRequestService searchRequestService;
    private final UserService userService;
    private final UserUtil userUtil;
    private final UserDeleteVeto userDeleteVeto;
    private final PortalPageService portalPageService;
    private final PreDeleteUserErrorsManager preDeleteUserErrorsManager;
    private final BaseUrl baseUrlLocator;
    private UserService.DeleteUserValidationResult validationResult;
    private ArrayList<Project> projectsUserLeads;
    private ArrayList<ProjectComponent> componentsUserLeads;
    private Map<String, String> linkableWarnings;
    private Map<String, String> linkableErrors;
    private Map<String, String> projectLeadErrors;
    private Map<String, String> componentLeadWarnings;
    private UserManager.UserState userState;
    private MessageGenerator messageGen;
    boolean confirm;

    public DeleteUser(CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, SearchRequestService searchRequestService, UserService userService, UserUtil userUtil, PortalPageService portalPageService, UserPropertyManager userPropertyManager, UserManager userManager, UserDeleteVeto userDeleteVeto, PreDeleteUserErrorsManager preDeleteUserErrorsManager, BaseUrl baseUrlLocator) {
        super(crowdService, crowdDirectoryService, userPropertyManager, userManager);
        this.searchRequestService = searchRequestService;
        this.userService = userService;
        this.userUtil = userUtil;
        this.portalPageService = portalPageService;
        this.userDeleteVeto = userDeleteVeto;
        this.preDeleteUserErrorsManager = preDeleteUserErrorsManager;
        this.baseUrlLocator = baseUrlLocator;
    }

    @Override
    protected void doValidation() {
        this.validationResult = this.userService.validateDeleteUser(this.getLoggedInApplicationUser(), this.getName());
        if (!this.validationResult.isValid()) {
            this.addErrorCollection(this.validationResult.getErrorCollection());
        }
        super.doValidation();
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        try {
            if (this.confirm) {
                this.userService.removeUser(this.getLoggedInApplicationUser(), this.validationResult);
            }
        }
        catch (Exception e) {
            this.addErrorMessage(this.getText("admin.errors.users.exception.trying.to.remove", e));
        }
        if (this.getHasErrorMessages()) {
            return "error";
        }
        return this.returnCompleteWithInlineRedirect("UserBrowser.jspa");
    }

    public UserService.DeleteUserValidationResult getValidationResult() {
        if (this.validationResult == null) {
            this.validationResult = this.userService.validateDeleteUser(this.getLoggedInApplicationUser(), this.getName());
        }
        return this.validationResult;
    }

    public boolean isDeleteable() {
        try {
            return this.getValidationResult().isValid();
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public boolean isNonSysAdminAttemptingToDeleteSysAdmin() {
        return this.userUtil.isNonSysAdminAttemptingToDeleteSysAdmin(this.getLoggedInUser(), this.getUser());
    }

    public Collection<Project> getProjectsUserLeads() {
        if (this.projectsUserLeads == null) {
            this.projectsUserLeads = new ArrayList(this.userUtil.getProjectsLeadBy(this.getUser()));
        }
        return this.projectsUserLeads;
    }

    public Collection<ProjectComponent> getComponentsUserLeads() {
        if (this.componentsUserLeads == null) {
            this.componentsUserLeads = new ArrayList(this.userUtil.getComponentsUserLeads(this.getUser()));
        }
        return this.componentsUserLeads;
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    private MessageGenerator getMessageGenerator() {
        if (this.messageGen == null) {
            this.messageGen = this.getUserState().isInMultipleDirectories() ? new DoNotGenerateErrorMessages() : new GenerateErrorMessages(this.preDeleteUserErrorsManager, this.getApplicationUser());
        }
        return this.messageGen;
    }

    public Map<String, String> getLinkableWarnings() {
        if (this.linkableWarnings == null) {
            this.linkableWarnings = this.getMessageGenerator().getWarnings();
        }
        return this.linkableWarnings;
    }

    public Map<String, String> getLinkableErrors() {
        if (this.linkableErrors == null) {
            this.linkableErrors = this.getMessageGenerator().getErrors();
        }
        return this.linkableErrors;
    }

    public Map<String, String> getProjectsUserLeadsError() {
        if (this.projectLeadErrors == null) {
            this.projectLeadErrors = this.getMessageGenerator().getProjectsUserLeadsError();
        }
        return this.projectLeadErrors;
    }

    public Map<String, String> getComponentsUserLeadsWarning() {
        if (this.componentLeadWarnings == null) {
            this.componentLeadWarnings = this.getMessageGenerator().getComponentsUserLeadsWarning();
        }
        return this.componentLeadWarnings;
    }

    public UserManager.UserState getUserState() {
        if (this.userState == null) {
            this.userState = this.userManager.getUserState(this.getUser());
        }
        return this.userState;
    }

    public boolean isSelfDestruct() {
        ApplicationUser me = this.getLoggedInApplicationUser();
        return me != null && me.equals(this.getApplicationUser());
    }

    static class DoNotGenerateErrorMessages
    implements MessageGenerator {
        DoNotGenerateErrorMessages() {
        }

        @Override
        public Map<String, String> getWarnings() {
            return ImmutableMap.of();
        }

        @Override
        public Map<String, String> getErrors() {
            return ImmutableMap.of();
        }

        @Override
        public Map<String, String> getProjectsUserLeadsError() {
            return ImmutableMap.of();
        }

        @Override
        public Map<String, String> getComponentsUserLeadsWarning() {
            return ImmutableMap.of();
        }
    }

    private class GenerateErrorMessages
    implements MessageGenerator {
        private final PreDeleteUserErrorsManager preDeleteUserErrorsManager;
        private final ImmutableList<WebErrorMessage> pluginErrorMessages;
        private final ApplicationUser user;

        public GenerateErrorMessages(PreDeleteUserErrorsManager preDeleteUserErrorsManager, ApplicationUser user) {
            this.preDeleteUserErrorsManager = preDeleteUserErrorsManager;
            this.pluginErrorMessages = this.getPluginErrorMessages(user.getDirectoryUser());
            this.user = user;
        }

        @Override
        public Map<String, String> getWarnings() {
            long numComponentsUserLeads;
            long numOtherFavouritedPortalPages;
            long numNonPrivatePortalPages;
            long numFilterFavoritedByOthers;
            HashMap linkableWarningMessages = Maps.newHashMap();
            ApplicationUser userForDelete = DeleteUser.this.getApplicationUser();
            long numSharedFilters = DeleteUser.this.searchRequestService.getNonPrivateFilters(userForDelete).size();
            if (numSharedFilters > 0L) {
                UrlBuilder urlBuilder = this.newUrlBuilder();
                urlBuilder.addPaths("/secure/admin/filters/ViewSharedFilters.jspa");
                urlBuilder.addParameter("searchOwnerUserName", this.user.getName());
                linkableWarningMessages.put(DeleteUser.this.getText("admin.deleteuser.filters.created.counted", numSharedFilters), urlBuilder.asUrlString());
            }
            if ((numFilterFavoritedByOthers = (long)DeleteUser.this.searchRequestService.getFiltersFavouritedByOthers(userForDelete).size()) > 0L) {
                linkableWarningMessages.put(DeleteUser.this.getText("admin.deleteuser.filters.favourited.counted", numFilterFavoritedByOthers), null);
            }
            if ((numNonPrivatePortalPages = (long)DeleteUser.this.portalPageService.getNonPrivatePortalPages(DeleteUser.this.getApplicationUser()).size()) > 0L) {
                UrlBuilder urlBuilder = this.newUrlBuilder();
                urlBuilder.addPaths("/secure/admin/dashboards/ViewSharedDashboards.jspa");
                urlBuilder.addParameter("searchOwnerUserName", this.user.getName());
                linkableWarningMessages.put(DeleteUser.this.getText("admin.deleteuser.portalpages.created.counted", numNonPrivatePortalPages), urlBuilder.asUrlString());
            }
            if ((numOtherFavouritedPortalPages = (long)DeleteUser.this.portalPageService.getPortalPagesFavouritedByOthers(userForDelete).size()) > 0L) {
                linkableWarningMessages.put(DeleteUser.this.getText("admin.deleteuser.portalpages.favourited.counted", numNonPrivatePortalPages), null);
            }
            if ((numComponentsUserLeads = (long)DeleteUser.this.userUtil.getComponentsUserLeads(userForDelete).size()) > 0L) {
                linkableWarningMessages.put(DeleteUser.this.getText("admin.deleteuser.components.lead.counted", numComponentsUserLeads), null);
            }
            return linkableWarningMessages;
        }

        @Override
        public Map<String, String> getErrors() {
            long numProjectsUserLeads;
            long numCommentedIssues;
            HashMap webErrorMessages = Maps.newHashMap();
            for (WebErrorMessage pluginErrorMessage : this.pluginErrorMessages) {
                webErrorMessages.put(pluginErrorMessage.getSnippet(), pluginErrorMessage.getURI().toString());
            }
            long numAssignedIssues = 0L;
            try {
                numAssignedIssues = DeleteUser.this.userUtil.getNumberOfAssignedIssuesIgnoreSecurity(DeleteUser.this.getLoggedInUser(), DeleteUser.this.getUser());
            }
            catch (SearchException e) {
                DeleteUser.this.log.error((Object)e, (Throwable)e);
            }
            if (numAssignedIssues > 0L) {
                UrlBuilder urlBuilder = this.newUrlBuilder();
                urlBuilder.addPaths("/secure/IssueNavigator.jspa");
                urlBuilder.addParameter("reset", "true");
                urlBuilder.addParameter("mode", "hide");
                urlBuilder.addParameter("sorter/order", "ASC");
                urlBuilder.addParameter("sorter/field", "priority");
                urlBuilder.addParameter("assigneeSelect", "specificuser");
                urlBuilder.addParameter("assignee", this.user.getName());
                webErrorMessages.put(DeleteUser.this.getText("admin.deleteuser.assigned.issues.counted", numAssignedIssues), urlBuilder.asUrlString());
            }
            long numReportedIssues = 0L;
            try {
                numReportedIssues = DeleteUser.this.userUtil.getNumberOfReportedIssuesIgnoreSecurity(DeleteUser.this.getLoggedInUser(), DeleteUser.this.getUser());
            }
            catch (SearchException e) {
                DeleteUser.this.log.error((Object)e, (Throwable)e);
            }
            if (numReportedIssues > 0L) {
                UrlBuilder urlBuilder = this.newUrlBuilder();
                urlBuilder.addPaths("/secure/IssueNavigator.jspa");
                urlBuilder.addParameter("reset", "true");
                urlBuilder.addParameter("mode", "hide");
                urlBuilder.addParameter("sorter/order", "ASC");
                urlBuilder.addParameter("sorter/field", "priority");
                urlBuilder.addParameter("reporterSelect", "specificuser");
                urlBuilder.addParameter("reporter", this.user.getName());
                webErrorMessages.put(DeleteUser.this.getText("admin.deleteuser.reported.issues.counted", numReportedIssues), urlBuilder.asUrlString());
            }
            if ((numCommentedIssues = DeleteUser.this.userDeleteVeto.getCommentCountByAuthor(DeleteUser.this.getApplicationUser())) > 0L) {
                webErrorMessages.put(DeleteUser.this.getText("admin.deleteuser.issue.comments.counted", numCommentedIssues), null);
            }
            if ((numProjectsUserLeads = (long)DeleteUser.this.userUtil.getProjectsLeadBy(DeleteUser.this.getUser()).size()) > 0L) {
                webErrorMessages.put(DeleteUser.this.getText("admin.deleteuser.projects.lead.counted", numProjectsUserLeads), null);
            }
            return webErrorMessages;
        }

        @Override
        public Map<String, String> getProjectsUserLeadsError() {
            HashMap projectNamesAndURLs = Maps.newHashMap();
            for (Project project : DeleteUser.this.getProjectsUserLeads()) {
                UrlBuilder fullURL = this.newUrlBuilder();
                fullURL.addPaths("/plugins/servlet/project-config");
                fullURL.addPaths("/" + project.getKey() + "/summary");
                projectNamesAndURLs.put(project.getName(), fullURL.asUrlString());
            }
            return projectNamesAndURLs;
        }

        @Override
        public Map<String, String> getComponentsUserLeadsWarning() {
            HashMap componentNamesAndURLs = Maps.newHashMap();
            for (ProjectComponent component : DeleteUser.this.getComponentsUserLeads()) {
                UrlBuilder fullURL = this.newUrlBuilder();
                fullURL.addPaths("/plugins/servlet/project-config");
                Project project = DeleteUser.this.getProjectManager().getProjectObj(component.getProjectId());
                fullURL.addPaths("/" + project.getKey() + "/components");
                componentNamesAndURLs.put(component.getName(), fullURL.asUrlString());
            }
            return componentNamesAndURLs;
        }

        ImmutableList<WebErrorMessage> getPluginErrorMessages(User user) {
            return this.preDeleteUserErrorsManager.getWarnings(user);
        }

        private UrlBuilder newUrlBuilder() {
            String base = DeleteUser.this.baseUrlLocator.getBaseUrl();
            if (StringUtils.isEmpty((String)base)) {
                base = "/";
            }
            return new UrlBuilder(base);
        }
    }

    static interface MessageGenerator {
        public Map<String, String> getWarnings();

        public Map<String, String> getErrors();

        public Map<String, String> getProjectsUserLeadsError();

        public Map<String, String> getComponentsUserLeadsWarning();
    }
}

