/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.event.web.action.admin.UserAddedEvent;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.plugin.user.WebErrorMessage;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@WebSudoRequired
public class AddUser
extends JiraWebActionSupport {
    private String username;
    private String password;
    private String confirm;
    private String fullname;
    private String email;
    private Long directoryId;
    private boolean sendEmail = false;
    private UserService.CreateUserValidationResult result;
    private List<WebErrorMessage> passwordErrors = ImmutableList.of();
    private final UserService userService;
    private final UserUtil userUtil;
    private final UserManager userManager;
    private final WebInterfaceManager webInterfaceManager;
    private final EventPublisher eventPublisher;

    public AddUser(UserService userService, UserUtil userUtil, UserManager userManager, WebInterfaceManager webInterfaceManager, EventPublisher eventPublisher) {
        this.userService = userService;
        this.userUtil = userUtil;
        this.userManager = userManager;
        this.webInterfaceManager = webInterfaceManager;
        this.eventPublisher = eventPublisher;
    }

    public String doDefault() {
        return "input";
    }

    protected void doValidation() {
        this.result = this.userService.validateCreateUserForAdmin(this.getLoggedInUser(), this.getUsername(), this.getPassword(), this.getConfirm(), this.getEmail(), this.getFullname(), this.getDirectoryId());
        if (!this.result.isValid()) {
            this.addErrorCollection(this.result.getErrorCollection());
        }
        this.passwordErrors = this.result.getPasswordErrors();
    }

    @RequiresXsrfCheck
    protected String doExecute() {
        try {
            if (this.sendEmail) {
                this.userService.createUserWithNotification(this.result);
            } else {
                this.userService.createUserNoNotification(this.result);
            }
            this.eventPublisher.publish((Object)new UserAddedEvent(this.request.getParameterMap()));
        }
        catch (PermissionException e) {
            this.addError("username", this.getText("admin.errors.user.no.permission.to.create"));
        }
        catch (CreateException e) {
            this.addError("username", this.getText("admin.errors.user.cannot.create", e.getMessage()));
        }
        if (this.getHasErrorMessages()) {
            return "error";
        }
        return this.returnCompleteWithInlineRedirect("ViewUser.jspa?name=" + JiraUrlCodec.encode((String)this.username.toLowerCase()));
    }

    public boolean hasReachedUserLimit() {
        return !this.userUtil.canActivateNumberOfUsers(1);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = StringUtils.trim((String)username);
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = StringUtils.trim((String)email);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = StringUtils.isEmpty((String)password) ? null : password;
    }

    public List<WebErrorMessage> getPasswordErrors() {
        return this.passwordErrors;
    }

    public boolean hasPasswordWritableDirectory() {
        return this.userManager.hasPasswordWritableDirectory();
    }

    public boolean isSendEmail() {
        return this.sendEmail;
    }

    public void setSendEmail(boolean sendEmail) {
        this.sendEmail = sendEmail;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = StringUtils.isEmpty((String)confirm) ? null : confirm;
    }

    public Long getDirectoryId() {
        return this.directoryId;
    }

    public void setDirectoryId(Long directoryId) {
        this.directoryId = directoryId;
    }

    public List<Directory> getDirectories() {
        return this.userManager.getWritableDirectories();
    }

    public Map<Long, Boolean> getCanDirectoryUpdatePasswordMap() {
        List<Directory> directories = this.getDirectories();
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(directories.size());
        for (Directory directory : directories) {
            result.put(directory.getId(), this.userManager.canDirectoryUpdateUserPassword(directory));
        }
        return result;
    }

    public String getUserCountWebPanelHtml() {
        return this.getPanels("webpanels.admin.adduser.count");
    }

    public String getWebPanelHtml() {
        return this.getPanels("webpanels.admin.adduser");
    }

    private String getPanels(String panelLocation) {
        StringBuilder builder = new StringBuilder();
        List panels = this.webInterfaceManager.getDisplayableWebPanelDescriptors(panelLocation, Collections.emptyMap());
        for (WebPanelModuleDescriptor panel : panels) {
            builder.append(((WebPanel)panel.getModule()).getHtml(Collections.emptyMap()));
        }
        return builder.toString();
    }
}

