/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.statuses;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.config.ConstantsService;
import com.atlassian.jira.bc.config.StatusService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.status.SimpleStatus;
import com.atlassian.jira.issue.status.SimpleStatusImpl;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.ActionViewDataMappings;
import com.atlassian.jira.web.action.admin.constants.AbstractViewConstants;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.atlassian.jira.web.util.HelpUtil;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class ViewStatuses
extends AbstractViewConstants {
    @VisibleForTesting
    static final String NEW_STATUS_DEFAULT_ICON = "/images/icons/statuses/generic.png";
    public static final String STATUS_ENTITY_NAME = "Status";
    private static final String CATEGORY_HELP_UTIL_KEY = "statuses";
    private final StatusService statusService;
    private final ConstantsService constantsService;
    private final WorkflowManager workflowManager;
    private Long statusCategory;
    public static final Function<JiraWorkflow, String> GET_WORKFLOW_NAME = new Function<JiraWorkflow, String>(){

        public String apply(@Nullable JiraWorkflow input) {
            return input.getName();
        }
    };

    @Deprecated
    public ViewStatuses(TranslationManager translationManager, StatusManager statusManager, WorkflowManager workflowManager) {
        super(translationManager);
        this.workflowManager = workflowManager;
        this.setIconurl(NEW_STATUS_DEFAULT_ICON);
        this.statusService = (StatusService)ComponentAccessor.getComponent(StatusService.class);
        this.constantsService = (ConstantsService)ComponentAccessor.getComponent(ConstantsService.class);
    }

    public ViewStatuses(TranslationManager translationManager, StatusService statusService, ConstantsService constantsService, I18nHelper i18nHelper, WorkflowManager workflowManager) {
        super(translationManager);
        this.statusService = statusService;
        this.constantsService = constantsService;
        this.workflowManager = workflowManager;
        this.setIconurl(NEW_STATUS_DEFAULT_ICON);
    }

    @Override
    protected String getConstantEntityName() {
        return STATUS_ENTITY_NAME;
    }

    @Override
    protected String getNiceConstantName() {
        return "status";
    }

    @Override
    protected String getIssueConstantField() {
        return this.getText("admin.issue.constant.status.lowercase");
    }

    @Override
    protected GenericValue getConstant(String id) {
        return this.getConstantsManager().getStatus(id);
    }

    @Override
    protected String getRedirectPage() {
        return "ViewStatuses.jspa";
    }

    @Override
    protected Collection<GenericValue> getConstants() {
        return this.getConstantsManager().getStatuses();
    }

    @Override
    protected void clearCaches() {
        this.getConstantsManager().refreshStatuses();
    }

    public Long getStatusCategory() {
        return this.statusCategory;
    }

    public void setStatusCategory(Long statusCategory) {
        this.statusCategory = statusCategory;
    }

    @RequiresXsrfCheck
    public String doAddStatus() throws Exception {
        ServiceResult validationResult = this.statusService.validateCreateStatus(this.getLoggedInApplicationUser(), this.name, this.description, this.getIconurl(), this.getStatusCategoryObject());
        this.addErrorCollection(validationResult.getErrorCollection());
        if (this.hasAnyErrors()) {
            return "error";
        }
        return super.doAddConstant();
    }

    @ActionViewData(key="status")
    public SimpleStatus getStatusFormValues() {
        return new SimpleStatusImpl(null, this.getName(), this.getDescription(), this.getStatusCategoryObject(), this.getIconurl());
    }

    @ActionViewData
    public Collection<SimpleStatus> getStatuses() {
        List workflows = this.workflowManager.getWorkflowsIncludingDrafts();
        return Collections2.transform((Collection)this.getConstantsManager().getStatusObjects(), (Function)new StatusMappingFunction(workflows));
    }

    @Override
    @ActionViewData(key="isTranslatable")
    public boolean isTranslatable() {
        return super.isTranslatable();
    }

    @ActionViewData(key="isIconUrlFieldVisible")
    public boolean isIconUrlFieldVisible() {
        return !this.getStatusLozengeEnabled();
    }

    @ActionViewDataMappings(value={"success", "error"})
    public Map<String, Object> outputErrorsForSoy() {
        return MapBuilder.newBuilder().add((Object)"errors", (Object)super.getErrors()).toMap();
    }

    @ActionViewData
    public String getToken() {
        return super.getXsrfToken();
    }

    @ActionViewData
    public HelpUtil.HelpPath getStatusCategoryHelpData() {
        return HelpUtil.getInstance().getHelpPath(CATEGORY_HELP_UTIL_KEY);
    }

    @Override
    protected String redirectToView() {
        return this.returnCompleteWithInlineRedirect("ViewStatuses.jspa");
    }

    @Override
    protected String getDefaultPropertyName() {
        return "jira.constant.default.status";
    }

    @Override
    protected GenericValue addConstant() throws GenericEntityException {
        StatusCategory statusCategoryObject = this.getStatusCategoryObject();
        ServiceOutcome status = this.statusService.createStatus(this.getLoggedInApplicationUser(), this.name, this.description, this.getIconurl(), statusCategoryObject);
        return ((Status)status.getReturnedValue()).getGenericValue();
    }

    private StatusCategory getStatusCategoryObject() {
        StatusCategory statusCategoryObject = this.getStatusLozengeEnabled() ? (StatusCategory)this.constantsService.getStatusCategoryById(this.getLoggedInUser(), String.valueOf(this.statusCategory)).getReturnedValue() : (StatusCategory)this.constantsService.getDefaultStatusCategory(this.getLoggedInUser()).getReturnedValue();
        return statusCategoryObject;
    }

    public boolean getStatusLozengeEnabled() {
        return this.constantsService.isStatusAsLozengeEnabled();
    }

    @ActionViewData
    public Collection<Map<String, Object>> getStatusCategoryOptions() {
        Collection<Map<String, Object>> options = Collections.emptyList();
        if (this.getStatusLozengeEnabled()) {
            Collection sc = (Collection)this.constantsService.getUserVisibleStatusCategories(this.getLoggedInUser()).getReturnedValue();
            options = Collections2.transform((Collection)sc, (Function)new Function<StatusCategory, Map<String, Object>>(){

                public Map<String, Object> apply(@Nullable StatusCategory input) {
                    MapBuilder builder = MapBuilder.newBuilder();
                    if (null != input) {
                        builder.add((Object)"text", (Object)input.getTranslatedName(ViewStatuses.this.getI18nHelper()));
                        builder.add((Object)"value", (Object)input.getId());
                        builder.add((Object)"key", (Object)input.getKey());
                        builder.add((Object)"colorName", (Object)input.getColorName());
                        builder.add((Object)"sequence", (Object)input.getSequence());
                        builder.add((Object)"selected", (Object)(null != input.getId() && input.getId().equals(ViewStatuses.this.getStatusCategory()) ? 1 : 0));
                    }
                    return builder.toMap();
                }
            });
        }
        return options;
    }

    public static Predicate<JiraWorkflow> containsStatus(final Status status) {
        return new Predicate<JiraWorkflow>(){

            public boolean apply(@Nullable JiraWorkflow input) {
                return input.getLinkedStatusObjects().contains(status);
            }
        };
    }

    private class StatusMappingFunction
    implements Function<Status, SimpleStatus> {
        private final List<JiraWorkflow> allWorkflows;

        private StatusMappingFunction(List<JiraWorkflow> allWorkflows) {
            this.allWorkflows = allWorkflows;
        }

        public SimpleStatus apply(@Nullable Status status) {
            ImmutableList workflows = ImmutableList.copyOf((Iterable)Iterables.filter(this.allWorkflows, ViewStatuses.containsStatus(status)));
            return new SimpleStatusMap(status, (List<JiraWorkflow>)workflows);
        }
    }

    public class SimpleStatusMap
    extends SimpleStatusImpl
    implements SimpleStatus {
        private final Collection<String> workflows;
        private final boolean isActive;

        public SimpleStatusMap(Status status, List<JiraWorkflow> workflows) {
            super(status);
            this.workflows = ImmutableSet.copyOf((Iterable)Iterables.transform(workflows, GET_WORKFLOW_NAME));
            this.isActive = null != workflows && workflows.size() > 0;
        }

        public Collection<String> getWorkflows() {
            return this.workflows;
        }

        public boolean getIsActive() {
            return this.isActive;
        }
    }
}

