/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.statuses;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.config.StatusService;
import com.atlassian.jira.issue.status.SimpleStatus;
import com.atlassian.jira.issue.status.SimpleStatusImpl;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.admin.constants.AbstractDeleteConstant;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class DeleteStatus
extends AbstractDeleteConstant {
    private final StatusService statusService;

    public DeleteStatus(StatusService statusService) {
        this.statusService = statusService;
    }

    @Override
    protected String getConstantEntityName() {
        return "Status";
    }

    @Override
    protected String getNiceConstantName() {
        return "status";
    }

    @Override
    protected String getIssueConstantField() {
        return "status";
    }

    @Override
    protected GenericValue getConstant(String id) {
        return this.getConstantsManager().getStatus(id);
    }

    @Override
    protected String getRedirectPage() {
        return "ViewStatuses.jspa";
    }

    @Override
    protected Collection<GenericValue> getConstants() {
        return this.getConstantsManager().getStatuses();
    }

    @Override
    protected void clearCaches() {
        this.getConstantsManager().refreshStatuses();
    }

    @Override
    protected void doValidation() {
        ServiceResult validationResult = this.statusService.validateRemoveStatus(this.getLoggedInApplicationUser(), this.getStatusObject());
        if (!validationResult.isValid()) {
            this.addErrorCollection(validationResult.getErrorCollection());
        }
    }

    private Status getStatusObject() {
        return this.statusService.getStatusById(this.getLoggedInApplicationUser(), this.id);
    }

    @ActionViewData(key="status")
    public SimpleStatus getStatusFormValues() {
        return new SimpleStatusImpl(this.getStatusObject());
    }

    @ActionViewData
    public Collection<String> getErrorMessages() {
        return super.getErrorMessages();
    }

    @ActionViewData
    public String getToken() {
        return super.getXsrfToken();
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.confirm) {
            this.statusService.removeStatus(this.getLoggedInApplicationUser(), this.getStatusObject());
        }
        if (this.getHasErrorMessages()) {
            return "error";
        }
        return this.returnCompleteWithInlineRedirect(this.getRedirectPage());
    }
}

