/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.scheme.distiller;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.scheme.SchemeManagerFactory;
import com.atlassian.jira.web.action.admin.scheme.AbstractSchemePickerAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import webwork.action.ActionContext;

@WebSudoRequired
public class SchemeTypePickerAction
extends AbstractSchemePickerAction {
    public static final String SELECTED_SCHEMES_SESSION_KEY = "__selectedSchemesKey";

    public SchemeTypePickerAction(SchemeManagerFactory schemeManagerFactory, SchemeFactory schemeFactory, ApplicationProperties applicationProperties) {
        super(schemeManagerFactory, schemeFactory, applicationProperties);
    }

    @Override
    public String doDefault() {
        this.clearSessionVariables();
        return super.doDefault();
    }

    @Override
    public void doValidation() {
    }

    @Override
    public String doSwitch() {
        this.clearSessionVariables();
        return super.doSwitch();
    }

    @Override
    protected String doExecute() throws Exception {
        SchemeManager schemeManager = this.getSchemeManager(this.getSelectedSchemeType());
        if ("associated".equals(this.getTypeOfSchemesToDisplay())) {
            ActionContext.getSession().put(SELECTED_SCHEMES_SESSION_KEY, schemeManager.getAssociatedSchemes(true));
        } else if ("all".equals(this.getTypeOfSchemesToDisplay())) {
            ActionContext.getSession().put(SELECTED_SCHEMES_SESSION_KEY, this.getSchemeFactory().getSchemesWithEntitiesComparable(schemeManager.getSchemes()));
        }
        return this.forceRedirect("SchemeMerge!default.jspa?typeOfSchemesToDisplay=" + this.getTypeOfSchemesToDisplay() + "&selectedSchemeType=" + this.getSelectedSchemeType());
    }

    public String doSelectSchemes() {
        this.clearSessionVariables();
        ActionContext.getSession().put(SELECTED_SCHEMES_SESSION_KEY, this.getSchemeObjs());
        return this.forceRedirect("SchemeMerge!default.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=" + this.getSelectedSchemeType());
    }

    @Override
    public String getRedirectPage() {
        return null;
    }

    private void clearSessionVariables() {
        ActionContext.getSession().remove(SELECTED_SCHEMES_SESSION_KEY);
        ActionContext.getSession().remove("__distilledSchemesKey");
    }

    @Override
    public String getToolName() {
        return "SchemeComparisonTool";
    }
}

