/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.notification;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.notification.NotificationType;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.notification.SchemeAwareNotificationAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class DeleteNotification
extends SchemeAwareNotificationAction {
    private Long id;
    private boolean confirmed = false;

    protected void doValidation() {
        if (this.id == null) {
            this.addErrorMessage(this.getText("admin.errors.notifications.must.select.notification.to.delete"));
        }
        if (!this.confirmed) {
            this.addErrorMessage(this.getText("admin.errors.notifications.confirm.deletion"));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.getSchemeManager().deleteEntity(this.getId());
        if (this.getSchemeId() == null) {
            return this.getRedirect("ViewNotificationSchemes.jspa");
        }
        return this.getRedirect("EditNotifications!default.jspa?schemeId=" + this.getSchemeId());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    private GenericValue getNotification() throws GenericEntityException {
        return this.getSchemeManager().getEntity(this.id);
    }

    public String getNotificationName() throws GenericEntityException {
        return this.getType(this.getNotification().getString("type")).getDisplayName();
    }

    public String getEventName() throws GenericEntityException {
        return ComponentAccessor.getEventTypeManager().getEventType(this.getNotification().getLong("eventTypeId")).getTranslatedName(this.getLoggedInUser());
    }

    @Override
    public NotificationType getType(String id) {
        return ManagerFactory.getNotificationTypeManager().getNotificationType(id);
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    @Override
    public SchemeManager getSchemeManager() {
        return ComponentAccessor.getNotificationSchemeManager();
    }

    @Override
    public String getRedirectURL() {
        return null;
    }
}

