/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuetypes.pro;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.context.manager.JiraContextTreeManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.option.IssueConstantOption;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.fields.option.ProjectOption;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ExceptionUtil;
import com.atlassian.jira.util.ofbiz.GenericValueUtils;
import com.atlassian.jira.web.action.admin.issuetypes.AbstractManageIssueTypeOptionsAction;
import com.atlassian.jira.web.action.admin.issuetypes.IssueTypeManageableOption;
import com.atlassian.jira.web.action.admin.issuetypes.pro.AssociateIssueTypeSchemes;
import com.atlassian.query.Query;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.ListOrderedMap;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class SelectIssueTypeSchemeForProject
extends AssociateIssueTypeSchemes {
    private static final String CREATE_SCHEME = "createScheme";
    private static final String CHOOSE_SCHEME = "chooseScheme";
    private static final String CHOOSE_PROJECT = "chooseProject";
    private Long projectId;
    private String createType;
    private Long sameAsProjectId;
    private String[] selectedOptions;
    private long subTaskCount = -1L;
    private long standardIssuesCount = -1L;

    public SelectIssueTypeSchemeForProject(FieldConfigSchemeManager configSchemeManager, IssueTypeSchemeManager issueTypeSchemeManager, FieldManager fieldManager, OptionSetManager optionSetManager, IssueTypeManageableOption manageableOptionType, BulkMoveOperation bulkMoveOperation, SearchProvider searchProvider, ProjectManager projectManager, JiraContextTreeManager treeManager, IssueManager issueManager) {
        super(configSchemeManager, issueTypeSchemeManager, fieldManager, optionSetManager, manageableOptionType, bulkMoveOperation, searchProvider, projectManager, treeManager, issueManager);
    }

    @Override
    public String doDefault() throws Exception {
        FieldConfigScheme currentScheme = this.getCurrentIssueTypeScheme();
        if (currentScheme != null) {
            this.setSchemeId(currentScheme.getId());
        }
        this.setCreateType(CHOOSE_SCHEME);
        return "input";
    }

    protected void doValidation() {
        if (CREATE_SCHEME.equals(this.getCreateType())) {
            FieldConfigScheme existingAutoCreatedScheme = this.getExistingAutoCreatedScheme();
            if (existingAutoCreatedScheme != null) {
                this.addErrorMessage(this.getText("admin.errors.already.an.issue.type.scheme.with.that.name"));
            }
            if (this.getSelectedOptions() != null) {
                boolean hasNormalIssueType = false;
                boolean hasSubTaskIssueType = false;
                for (int i = 0; i < this.getSelectedOptions().length; ++i) {
                    String id = this.getSelectedOptions()[i];
                    IssueType issueType = ComponentAccessor.getConstantsManager().getIssueTypeObject(id);
                    if (!issueType.isSubTask()) {
                        hasNormalIssueType = true;
                        continue;
                    }
                    hasSubTaskIssueType = true;
                }
                if (!hasNormalIssueType) {
                    this.addError("selectedOptions", this.getText("admin.errors.must.select.at.least.one.standard.issue.type"));
                }
                try {
                    if (!hasSubTaskIssueType && this.getSubTaskIssues() > 0L) {
                        this.addError("selectedOptions", this.getText("admin.errors.project.has.subtasks", "" + this.getSubTaskIssues()));
                    }
                }
                catch (SearchException e) {
                    this.addErrorMessage(this.getText("admin.projects.issuetypescheme.error.sever", ExceptionUtil.getExceptionAsHtml(e)));
                }
            } else {
                this.addError("selectedOptions", this.getText("admin.errors.must.select.at.least.one.standard.issue.type"));
            }
        } else if (CHOOSE_PROJECT.equals(this.getCreateType()) && this.sameAsProjectId == null) {
            this.addError("sameAsProjectId", this.getText("admin.projects.issuetypescheme.error.must.select.project"));
        }
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        FieldConfigScheme configScheme;
        if (CREATE_SCHEME.equals(this.getCreateType())) {
            FieldConfigScheme createdScheme = this.issueTypeSchemeManager.create(this.getDefaultNameForNewScheme(), "", EasyList.build((Object[])this.getSelectedOptions()));
            this.setConfigScheme(createdScheme);
        } else if (CHOOSE_PROJECT.equals(this.getCreateType())) {
            FieldConfigScheme schemeOfSelectedProject = this.configSchemeManager.getFieldConfigScheme(this.sameAsProjectId);
            this.setConfigScheme(schemeOfSelectedProject);
        }
        if (this.getCurrentIssueTypeScheme().equals(this.getConfigScheme())) {
            return this.getRedirect("/plugins/servlet/project-config/" + this.getProject().getString("key") + "/issuetypes");
        }
        if (this.getConfigScheme().isGlobal()) {
            this.setConfigScheme(this.getCurrentIssueTypeScheme());
            configScheme = this.getConfigScheme();
            List projectsList = configScheme.getAssociatedProjects();
            Long[] projectIds = GenericValueUtils.transformToLongIds((Collection)CollectionUtils.subtract((Collection)projectsList, (Collection)EasyList.build((Object)this.getProject())));
            this.setProjects(projectIds);
            String result = super.doExecute(false);
            ((Object)((Object)this)).getClass();
            if (result.equals("NO_REDIRECT")) {
                return this.getRedirect("/plugins/servlet/project-config/" + this.getProject().getString("key") + "/issuetypes");
            }
            return result;
        }
        configScheme = this.getConfigScheme();
        List associatedProjects = configScheme.getAssociatedProjects();
        ArrayList<Object> projectsList = associatedProjects != null && !associatedProjects.isEmpty() ? new ArrayList(associatedProjects) : new ArrayList<GenericValue>(1);
        projectsList.add(this.getProject());
        Long[] projectIds = GenericValueUtils.transformToLongIds(projectsList);
        this.setProjects(projectIds);
        String result = super.doExecute(false);
        ((Object)((Object)this)).getClass();
        if (result.equals("NO_REDIRECT")) {
            return this.getRedirect("/plugins/servlet/project-config/" + this.getProject().getString("key") + "/issuetypes");
        }
        return result;
    }

    public GenericValue getProject() {
        return this.projectManager.getProject(this.getProjectId());
    }

    public FieldConfigScheme getCurrentIssueTypeScheme() {
        return this.issueTypeSchemeManager.getConfigScheme(this.getProject());
    }

    @Override
    public Collection getAllProjects() throws Exception {
        return CollectionUtils.select((Collection)super.getAllProjects(), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                ProjectOption projectOption = (ProjectOption)((Object)object);
                return !SelectIssueTypeSchemeForProject.this.getProjectId().toString().equals(projectOption.getId());
            }
        });
    }

    public List getAllSchemes() {
        return this.issueTypeSchemeManager.getAllSchemes();
    }

    public FieldConfigScheme getConfigSchemeForProject(String project) {
        return this.issueTypeSchemeManager.getConfigScheme(this.projectManager.getProjectByName(project));
    }

    public Map getTypeOptions() throws Exception {
        ListOrderedMap typeOptions = new ListOrderedMap();
        typeOptions.put((Object)CHOOSE_SCHEME, (Object)this.getText("admin.projects.issuetypescheme.radio1"));
        if (!this.getAllProjects().isEmpty()) {
            typeOptions.put((Object)CHOOSE_PROJECT, (Object)this.getText("admin.projects.issuetypescheme.radio2"));
        }
        typeOptions.put((Object)CREATE_SCHEME, (Object)this.getText("admin.projects.issuetypescheme.radio4"));
        return typeOptions;
    }

    public String getDefaultNameForNewScheme() {
        return this.getText("admin.projects.issuetypescheme.new.issue.type", this.getProject().getString("name"));
    }

    public Collection getAllOptions() {
        Collection constantObjects = ComponentAccessor.getConstantsManager().getConstantObjects(this.getManageableOption().getFieldId());
        ArrayList options = new ArrayList(constantObjects);
        CollectionUtils.transform(options, (Transformer)new Transformer(){

            public Object transform(Object input) {
                return new IssueConstantOption((IssueConstant)input);
            }
        });
        return options;
    }

    public long getSubTaskIssues() throws SearchException {
        if (this.subTaskCount == -1L) {
            Query query = this.getQuery(EasyList.build((Object)this.getProjectId()), EasyList.build((Object)"-3"));
            this.subTaskCount = this.searchProvider.searchCount(query, this.getLoggedInUser());
        }
        return this.subTaskCount;
    }

    public long getStandardIssues() throws SearchException {
        if (this.standardIssuesCount == -1L) {
            Query query = this.getQuery(EasyList.build((Object)this.getProjectId()), EasyList.build((Object)"-2"));
            this.standardIssuesCount = this.searchProvider.searchCount(query, this.getLoggedInUser());
        }
        return this.standardIssuesCount;
    }

    public FieldConfigScheme getExistingAutoCreatedScheme() {
        Collection c = CollectionUtils.select((Collection)this.issueTypeSchemeManager.getAllSchemes(), (Predicate)new AbstractManageIssueTypeOptionsAction.FieldConfigPredicate(null, this.getDefaultNameForNewScheme()));
        if (c != null && !c.isEmpty()) {
            return (FieldConfigScheme)c.iterator().next();
        }
        return null;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getCreateType() {
        return this.createType;
    }

    public void setCreateType(String createType) {
        this.createType = createType;
    }

    public Long getSameAsProjectId() {
        return this.sameAsProjectId;
    }

    public void setSameAsProjectId(Long sameAsProjectId) {
        this.sameAsProjectId = sameAsProjectId;
    }

    public String[] getSelectedOptions() {
        return this.selectedOptions;
    }

    public void setSelectedOptions(String[] selectedOptions) {
        this.selectedOptions = selectedOptions;
    }
}

