/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuetypes;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.constants.AbstractDeleteConstant;
import com.atlassian.jira.web.action.admin.issuetypes.events.IssueTypeDeletedEventThroughUI;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class DeleteIssueType
extends AbstractDeleteConstant {
    private final IssueTypeManager issueTypeManager;
    private final EventPublisher eventPublisher;

    public DeleteIssueType(IssueTypeManager issueTypeManager, EventPublisher eventPublisher) {
        this.issueTypeManager = issueTypeManager;
        this.eventPublisher = eventPublisher;
    }

    @Override
    protected String getConstantEntityName() {
        return "IssueType";
    }

    @Override
    protected String getNiceConstantName() {
        return this.getText("admin.issue.constant.issuetype.lowercase");
    }

    @Override
    protected String getIssueConstantField() {
        return "type";
    }

    @Override
    protected GenericValue getConstant(String id) {
        return this.getConstantsManager().getIssueType(id);
    }

    protected IssueType getIssueTypeObject() {
        return this.getConstantsManager().getIssueTypeObject(this.id);
    }

    @Override
    protected String getRedirectPage() {
        return "ViewIssueTypes.jspa";
    }

    @Override
    protected Collection<GenericValue> getConstants() {
        return this.getConstantsManager().getIssueTypes();
    }

    @Override
    protected void clearCaches() {
        this.getConstantsManager().refreshIssueTypes();
        ComponentAccessor.getFieldManager().refresh();
    }

    @Override
    protected void doValidation() {
        try {
            if (this.getMatchingIssues().isEmpty()) {
                if (this.getConstant() == null) {
                    this.addErrorMessage(this.getText("admin.errors.no.constant.found", this.getNiceConstantName(), this.id));
                }
            } else {
                if (this.issueTypeManager.getAvailableIssueTypes(this.getIssueTypeObject()).isEmpty()) {
                    this.addErrorMessage(this.getText("admin.errors.issuetypes.no.alternative"));
                }
                super.doValidation();
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error occurred: " + e), (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.error.occurred") + " " + e);
        }
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.issueTypeManager.removeIssueType(this.id, this.newId);
        if (this.getHasErrorMessages()) {
            return "error";
        }
        this.eventPublisher.publish((Object)new IssueTypeDeletedEventThroughUI());
        return this.getRedirect(this.getRedirectPage());
    }

    public Collection getAvailableIssueTypes() throws GenericEntityException, WorkflowException {
        return this.issueTypeManager.getAvailableIssueTypes(this.getIssueTypeObject());
    }
}

