/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuetypes;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ComponentFactory;
import com.atlassian.jira.util.ofbiz.GenericValueUtils;
import com.atlassian.jira.web.action.admin.issuetypes.AbstractManageIssueTypeOptionsAction;
import com.atlassian.jira.web.action.admin.issuetypes.ConfigureOptionScheme;
import com.atlassian.jira.web.action.admin.issuetypes.IssueTypeManageableOption;
import com.atlassian.jira.web.action.admin.issuetypes.ProjectIssueTypeSchemeHelper;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

@WebSudoRequired
public class ConfigureIssueTypeOptionScheme
extends ConfigureOptionScheme {
    private final ComponentFactory componentFactory;
    private List<Project> associatedProjects;

    public ConfigureIssueTypeOptionScheme(FieldConfigSchemeManager configSchemeManager, IssueTypeSchemeManager issueTypeSchemeManager, FieldManager fieldManager, OptionSetManager optionSetManager, IssueTypeManageableOption manageableOptionType, BulkMoveOperation bulkMoveOperation, SearchProvider searchProvider, ConstantsManager constantsManager, IssueManager issueManager, ComponentFactory factory, EventPublisher eventPublisher) {
        super(configSchemeManager, issueTypeSchemeManager, fieldManager, optionSetManager, manageableOptionType, bulkMoveOperation, searchProvider, constantsManager, issueManager, eventPublisher);
        this.componentFactory = factory;
    }

    @Override
    protected void doValidation() {
        super.doValidation();
        if (CollectionUtils.exists((Collection)this.issueTypeSchemeManager.getAllSchemes(), (Predicate)new AbstractManageIssueTypeOptionsAction.FieldConfigPredicate(this.getSchemeId(), this.getName()))) {
            this.addError("name", this.getText("admin.errors.issuetypes.duplicate.name"));
        }
        if (this.getSelectedOptions() != null && this.getSelectedOptions().length > 0) {
            boolean hasNormalIssueType = false;
            for (int i = 0; i < this.getSelectedOptions().length; ++i) {
                String id = this.getSelectedOptions()[i];
                IssueType issueType = this.constantsManager.getIssueTypeObject(id);
                if (issueType.isSubTask()) continue;
                hasNormalIssueType = true;
                break;
            }
            if (!hasNormalIssueType) {
                this.addErrorMessage(this.getText("admin.errors.issuetypes.must.select.standard.issue.type"));
            }
        }
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        List associatedProjects = this.getConfigScheme().getAssociatedProjects();
        if (associatedProjects != null && !associatedProjects.isEmpty()) {
            List projectIds = GenericValueUtils.transformToLongIdsList((Collection)associatedProjects);
            Collection obseleteOptions = CollectionUtils.subtract(this.getOriginalOptions(), this.getNewOptions());
            if (obseleteOptions != null && !obseleteOptions.isEmpty()) {
                ArrayList<String> obseleteOptionIds = new ArrayList<String>(obseleteOptions.size());
                for (Option option : obseleteOptions) {
                    obseleteOptionIds.add(option.getId());
                }
                Query query = this.getQuery(projectIds, obseleteOptionIds);
                SearchResults searchResults = this.searchProvider.search(query, this.getLoggedInUser(), PagerFilter.getUnlimitedFilter());
                List affectedIssues = searchResults.getIssues();
                if (affectedIssues != null && !affectedIssues.isEmpty()) {
                    this.configScheme = new FieldConfigScheme.Builder(this.getConfigScheme()).setName(this.getName()).setDescription(this.getDescription()).toFieldConfigScheme();
                    ArrayList<String> optionIds = new ArrayList<String>(Arrays.asList(this.getSelectedOptions()));
                    return this.migrateIssues(this, affectedIssues, optionIds);
                }
            }
        }
        return super.doExecute();
    }

    public List<Project> getUsedIn() {
        if (this.associatedProjects == null) {
            ProjectIssueTypeSchemeHelper helper = this.componentFactory.createObject(ProjectIssueTypeSchemeHelper.class);
            this.associatedProjects = helper.getProjectsUsingScheme(this.getConfigScheme());
        }
        return this.associatedProjects;
    }

    @Override
    public boolean isAllowEditOptions() {
        return !this.issueTypeSchemeManager.getDefaultIssueTypeScheme().getId().equals(this.getSchemeId());
    }
}

