/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.index;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.web.action.admin.index.AbstractAsyncIndexerCommand;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import com.google.common.annotations.VisibleForTesting;
import org.apache.log4j.Logger;

@Internal
@VisibleForTesting
public class ReIndexBackgroundIndexerCommand
extends AbstractAsyncIndexerCommand {
    private final boolean reIndexComments;
    private final boolean reIndexChangeHistory;

    public ReIndexBackgroundIndexerCommand(IndexLifecycleManager indexManager, Logger log, I18nHelper i18nHelper, I18nHelper.BeanFactory i18nBeanFactory) {
        super(null, indexManager, log, i18nHelper, i18nBeanFactory);
        this.reIndexComments = false;
        this.reIndexChangeHistory = false;
    }

    public ReIndexBackgroundIndexerCommand(IndexLifecycleManager indexManager, boolean reIndexComments, boolean reIndexChangeHistory, Logger log, I18nHelper i18nHelper, I18nHelper.BeanFactory i18nBeanFactory) {
        super(null, indexManager, log, i18nHelper, i18nBeanFactory);
        this.reIndexComments = reIndexComments;
        this.reIndexChangeHistory = reIndexChangeHistory;
    }

    @Override
    public IndexCommandResult doReindex(Context context, IndexLifecycleManager indexManager) {
        long reindexTime = indexManager.reIndexAllIssuesInBackground(context, this.reIndexComments, this.reIndexChangeHistory);
        return new IndexCommandResult(reindexTime);
    }
}

