/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.index;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.index.ha.IndexRecoveryService;
import com.atlassian.jira.task.ProvidesTaskProgress;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

@Internal
@VisibleForTesting
public class IndexRecoveryCommand
implements Callable<IndexCommandResult>,
ProvidesTaskProgress {
    public static final String JIRA_INDEX_RECOVERY_MSG = "JIRA index is being recovered. Depending on how large the database is, this may take a few minutes. JIRA will automatically become available as soon as this task is complete.";
    private final ApplicationUser user;
    private final JohnsonEventContainer eventCont;
    private final IndexRecoveryService indexRecoveryService;
    private final Logger log;
    private final I18nHelper i18nHelper;
    private volatile TaskProgressSink taskProgressSink;
    private String recoveryFilename;

    public IndexRecoveryCommand(ApplicationUser user, JohnsonEventContainer eventCont, IndexRecoveryService indexRecoveryService, Logger log, I18nHelper i18nHelper, String recoveryFilename) {
        this.user = user;
        this.eventCont = eventCont;
        this.indexRecoveryService = indexRecoveryService;
        this.log = log;
        this.i18nHelper = i18nHelper;
        this.recoveryFilename = recoveryFilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexCommandResult call() throws Exception {
        Event appEvent = new Event(EventType.get((String)"reindex"), JIRA_INDEX_RECOVERY_MSG, EventLevel.get((String)"warning"));
        if (this.eventCont != null) {
            this.eventCont.addEvent(appEvent);
        }
        try {
            Context context = Contexts.percentageReporter((Sized)this.indexRecoveryService, (TaskProgressSink)this.taskProgressSink, (I18nHelper)this.i18nHelper, (Logger)this.log, (String)"Index Recovery", (Event)appEvent);
            this.log.info((Object)"Re-indexing started");
            IndexCommandResult indexCommandResult = this.indexRecoveryService.recoverIndexFromBackup(this.user, context, this.i18nHelper, this.recoveryFilename, this.taskProgressSink);
            return indexCommandResult;
        }
        finally {
            if (this.eventCont != null) {
                this.eventCont.removeEvent(appEvent);
            }
            this.log.info((Object)"Index Recovery finished");
        }
    }

    @Override
    public void setTaskProgressSink(TaskProgressSink taskProgressSink) {
        this.taskProgressSink = taskProgressSink;
    }
}

