/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.index;

import com.atlassian.jira.index.ha.IndexRecoveryService;
import com.atlassian.jira.issue.fields.option.TextOption;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.jira.web.action.admin.index.IndexRecoveryUtil;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;

@WebSudoRequired
public class EditIndexRecoverySettings
extends ProjectActionSupport {
    private final IndexRecoveryService indexRecoveryService;
    private boolean recoveryEnabled;
    private IndexRecoveryUtil.Interval snapshotInterval;

    public EditIndexRecoverySettings(ProjectManager projectManager, PermissionManager permissionManager, IndexRecoveryService indexRecoveryService) {
        super(projectManager, permissionManager);
        this.indexRecoveryService = indexRecoveryService;
    }

    public String doDefault() throws Exception {
        this.recoveryEnabled = this.indexRecoveryService.isRecoveryEnabled(this.getLoggedInApplicationUser());
        if (this.recoveryEnabled) {
            Long snapshotMillis = this.indexRecoveryService.getSnapshotInterval(this.getLoggedInApplicationUser());
            this.snapshotInterval = snapshotMillis == null ? IndexRecoveryUtil.DEFAULT_INTERVAL : IndexRecoveryUtil.intervalFromMillis(snapshotMillis);
        } else {
            this.recoveryEnabled = false;
            this.snapshotInterval = IndexRecoveryUtil.DEFAULT_INTERVAL;
        }
        return "input";
    }

    protected void doValidation() {
        super.doValidation();
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.indexRecoveryService.updateRecoverySettings(this.getLoggedInApplicationUser(), this.recoveryEnabled, this.snapshotInterval.getMillis());
        return this.returnComplete("IndexAdmin.jspa");
    }

    public boolean isRecoveryEnabled() {
        return this.recoveryEnabled;
    }

    public void setRecoveryEnabled(boolean recoveryEnabled) {
        this.recoveryEnabled = recoveryEnabled;
    }

    public String getSnapshotInterval() {
        return this.snapshotInterval.name();
    }

    public void setSnapshotInterval(String snapshotInterval) {
        this.snapshotInterval = IndexRecoveryUtil.Interval.valueOf(snapshotInterval);
    }

    public Collection<TextOption> getIntervalOptions() {
        return IndexRecoveryUtil.getIntervalOptions(this.getI18nHelper());
    }
}

