/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.index;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.web.action.admin.index.AbstractAsyncIndexerCommand;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import com.atlassian.johnson.JohnsonEventContainer;
import org.apache.log4j.Logger;

@Internal
public class ActivateAsyncIndexerCommand
extends AbstractAsyncIndexerCommand {
    private final boolean deactivateIndexFirst;

    public ActivateAsyncIndexerCommand(boolean deactivateIndexFirst, JohnsonEventContainer eventCont, IndexLifecycleManager indexManager, Logger log, I18nHelper i18nHelper, I18nHelper.BeanFactory i18nBeanFactory) {
        super(eventCont, indexManager, log, i18nHelper, i18nBeanFactory);
        this.deactivateIndexFirst = deactivateIndexFirst;
    }

    @Override
    public IndexCommandResult doReindex(Context context, IndexLifecycleManager indexManager) {
        try {
            if (this.deactivateIndexFirst) {
                indexManager.deactivate();
            }
            long reindexTime = indexManager.activate(context);
            return new IndexCommandResult(reindexTime);
        }
        catch (Exception e) {
            this.getLog().error((Object)("Exception reindexing: " + e), (Throwable)e);
            SimpleErrorCollection errors = new SimpleErrorCollection();
            errors.addErrorMessage(this.getI18nHelper().getText("admin.errors.error.while.activating.indexes") + " " + e);
            return new IndexCommandResult((ErrorCollection)errors);
        }
    }
}

