/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.importer.project;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.imports.project.ProjectImportService;
import com.atlassian.jira.imports.project.ProjectImportTaskContext;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.MappingResult;
import com.atlassian.jira.imports.project.core.ProjectImportData;
import com.atlassian.jira.imports.project.core.ProjectImportOptions;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.taskprogress.TaskProgressInterval;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.task.ProvidesTaskProgress;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.importer.project.ProjectImportBean;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.List;
import java.util.concurrent.Callable;
import javax.servlet.ServletContext;
import webwork.action.ActionContext;
import webwork.action.ServletActionContext;

@WebSudoRequired
public class ProjectImportSummary
extends JiraWebActionSupport {
    private static final String PROJECT_IMPORT_JOHNSON_MSG = "JIRA is currently performing a project import. Depending on how large the imported project is, this may take any where from a few minutes to a few hours. Jira will automatically become available as soon as this task is complete.";
    private static final String REPETITIVE_SPACES_REGEXP = "(\\s(?=\\s)|(?<=\\s)\\s)";
    private static final String CONTAINS_REPETITIVE_SPACES_REGEXP = ".*(\\s(?=\\s)|(?<=\\s)\\s).*";
    private final ProjectImportService projectImportService;
    private final TaskManager taskManager;
    private MappingResult mappingResult;
    private ProjectImportData projectImportData;

    public ProjectImportSummary(ProjectImportService projectImportService, TaskManager taskManager) {
        this.projectImportService = projectImportService;
        this.taskManager = taskManager;
    }

    public String doDefault() throws Exception {
        if (this.getMappingResult() == null) {
            this.addErrorMessage(this.getText("admin.project.import.summary.no.mapping.result"));
            return "error";
        }
        ProjectImportBean projectImportBean = ProjectImportBean.getProjectImportBeanFromSession();
        if (projectImportBean.getTaskProgressInformation().getErrorCollection() != null) {
            this.addErrorCollection(projectImportBean.getTaskProgressInformation().getErrorCollection());
        }
        return super.doDefault();
    }

    public void doValidation() {
        if (this.getProjectImportData() == null) {
            this.addErrorMessage(this.getText("admin.project.import.summary.no.project.import.data"));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ProjectImportBean beanFromSession = ProjectImportBean.getProjectImportBeanFromSession();
        if (ActionContext.getParameters().get("prevButton") != null) {
            return this.forceRedirect("ProjectImportSelectProject!default.jspa?projectKey=" + beanFromSession.getSelectedProject().getProject().getKey());
        }
        if (ActionContext.getParameters().get("refreshValidationButton") != null) {
            return this.forceRedirect("ProjectImportSummary!reMapAndValidate.jspa");
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        beanFromSession.getTaskProgressInformation().setErrorCollection((ErrorCollection)errorCollection);
        BackupProject project = beanFromSession.getSelectedProject();
        ProjectImportData projectImportData = beanFromSession.getProjectImportData();
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(this.getLoggedInUser(), (ErrorCollection)errorCollection);
        ProjectImportCallable callableTask = new ProjectImportCallable(beanFromSession.getProjectImportOptions(), projectImportData, project, beanFromSession.getBackupOverview().getBackupSystemInformation(), (JiraServiceContext)serviceContext, beanFromSession);
        TaskDescriptor<ProjectImportResults> descriptor = this.taskManager.submitTask(callableTask, this.getText("admin.project.import.progress.task.description.importing", project.getProject().getName()), new ProjectImportTaskContext());
        beanFromSession.getTaskProgressInformation().setTaskId(descriptor.getTaskId());
        return this.getRedirect("/secure/admin/ProjectImportProgress.jspa?redirectOnComplete=ProjectImportResults.jspa");
    }

    public String doReMapAndValidate() {
        ProjectImportBean beanFromSession = ProjectImportBean.getProjectImportBeanFromSession();
        beanFromSession.setMappingResult(null);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        beanFromSession.getTaskProgressInformation().setErrorCollection((ErrorCollection)errorCollection);
        BackupProject project = beanFromSession.getBackupOverview().getProject(beanFromSession.getProjectImportOptions().getSelectedProjectKey());
        ProjectImportData projectImportData = beanFromSession.getProjectImportData();
        projectImportData.getProjectImportMapper().clearMappedValues();
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(this.getLoggedInUser(), (ErrorCollection)errorCollection);
        ReMappingResultCallable mappingResultCallable = new ReMappingResultCallable(beanFromSession.getProjectImportOptions(), projectImportData, project, beanFromSession.getBackupOverview().getBackupSystemInformation(), (JiraServiceContext)serviceContext);
        TaskDescriptor<MappingResult> descriptor = this.taskManager.submitTask(mappingResultCallable, this.getText("admin.project.import.progress.task.description.map.and.validate", project.getProject().getName()), new ProjectImportTaskContext());
        beanFromSession.getTaskProgressInformation().setTaskId(descriptor.getTaskId());
        return this.getRedirect("ProjectImportMappingProgress.jspa?redirectOnComplete=ProjectImportSummary!default.jspa");
    }

    public List<MappingResult.ValidationMessage> getSystemFieldsValidateMessages() {
        return this.getMappingResult().getSystemFieldsMessageList();
    }

    public List<MappingResult.ValidationMessage> getCustomFieldsValidateMessages() {
        return this.getMappingResult().getCustomFieldsMessageList();
    }

    public boolean isCanImport() {
        return this.getMappingResult().canImport();
    }

    public String getProjectName() {
        ProjectImportBean beanFromSession = ProjectImportBean.getProjectImportBeanFromSession();
        BackupProject project = beanFromSession.getSelectedProject();
        if (project == null) {
            return "";
        }
        return project.getProject().getName();
    }

    public String escapeValuePreserveSpaces(String value) {
        String escapedValue = TextUtils.htmlEncode((String)value);
        if (escapedValue.matches(CONTAINS_REPETITIVE_SPACES_REGEXP)) {
            return escapedValue.replaceAll(REPETITIVE_SPACES_REGEXP, "-") + " " + this.getText("admin.project.import.summary.repetitive.spaces");
        }
        return escapedValue;
    }

    public MappingResult getMappingResult() {
        if (this.mappingResult == null) {
            this.mappingResult = ProjectImportBean.getProjectImportBeanFromSession().getMappingResult();
        }
        return this.mappingResult;
    }

    private ProjectImportData getProjectImportData() {
        if (this.projectImportData == null) {
            this.projectImportData = ProjectImportBean.getProjectImportBeanFromSession().getProjectImportData();
        }
        return this.projectImportData;
    }

    private static class JohnsonUpdatingTaskProgressSink
    implements TaskProgressSink {
        private final Event johnsonEvent;
        private final TaskProgressSink delegate;

        public JohnsonUpdatingTaskProgressSink(Event johnsonEvent, TaskProgressSink taskProgressSink) {
            this.johnsonEvent = johnsonEvent;
            this.delegate = taskProgressSink;
        }

        public void makeProgress(long taskProgress, String currentSubTask, String message) {
            this.delegate.makeProgress(taskProgress, currentSubTask, message);
            this.johnsonEvent.setProgress((int)taskProgress);
        }
    }

    private class ProjectImportCallable
    implements Callable<ProjectImportResults>,
    ProvidesTaskProgress {
        private TaskProgressSink taskProgressSink;
        private final ProjectImportOptions projectImportOptions;
        private final ProjectImportData projectImportData;
        private final BackupProject selectedProject;
        private final BackupSystemInformation backupSystemInformation;
        private final Event johnsonEvent;
        private final JiraServiceContext serviceContext;
        private final ProjectImportBean projectImportBean;

        public ProjectImportCallable(ProjectImportOptions projectImportOptions, ProjectImportData projectImportData, BackupProject selectedProject, BackupSystemInformation backupSystemInformation, JiraServiceContext serviceContext, ProjectImportBean projectImportBean) {
            this.projectImportOptions = projectImportOptions;
            this.projectImportData = projectImportData;
            this.selectedProject = selectedProject;
            this.backupSystemInformation = backupSystemInformation;
            this.serviceContext = serviceContext;
            this.projectImportBean = projectImportBean;
            this.johnsonEvent = new Event(EventType.get((String)"project-import"), ProjectImportSummary.PROJECT_IMPORT_JOHNSON_MSG, EventLevel.get((String)"warning"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ProjectImportResults call() throws Exception {
            JohnsonEventContainer eventCont = null;
            ServletContext ctx = ServletActionContext.getServletContext();
            if (ctx != null) {
                eventCont = JohnsonEventContainer.get((ServletContext)ctx);
                eventCont.addEvent(this.johnsonEvent);
            }
            try {
                ProjectImportSummary.this.projectImportService.validateBackupProjectImportableSystemLevel(this.serviceContext, this.selectedProject, this.backupSystemInformation);
                ProjectImportSummary.this.projectImportService.validateDoMapping(this.serviceContext, this.projectImportOptions, this.selectedProject, this.backupSystemInformation);
                ErrorCollection errorCollection = this.serviceContext.getErrorCollection();
                if (errorCollection.hasAnyErrors()) {
                    errorCollection.addErrorMessage(ProjectImportSummary.this.getText("admin.project.import.summary.error.project.validation"));
                    this.projectImportBean.setProjectImportData(null);
                    this.projectImportBean.setMappingResult(null);
                    ProjectImportResults projectImportResults = null;
                    return projectImportResults;
                }
                this.projectImportData.getProjectImportMapper().clearMappedValues();
                TaskProgressInterval taskProgressInterval = new TaskProgressInterval(this.taskProgressSink, 0, 5);
                MappingResult mappingResult = ProjectImportSummary.this.projectImportService.doMapping(this.serviceContext, this.projectImportOptions, this.projectImportData, this.selectedProject, this.backupSystemInformation, taskProgressInterval);
                if (errorCollection.hasAnyErrors()) {
                    errorCollection.addErrorMessage(ProjectImportSummary.this.getText("admin.project.import.summary.error.mapping.validation"));
                    this.projectImportBean.setMappingResult(mappingResult);
                    ProjectImportResults projectImportResults = null;
                    return projectImportResults;
                }
                TaskProgressInterval importSubInterval = new TaskProgressInterval(this.taskProgressSink, 5, 100);
                ProjectImportResults projectImportResults = ProjectImportSummary.this.projectImportService.doImport(this.serviceContext, this.projectImportOptions, this.selectedProject, this.backupSystemInformation, this.projectImportData, importSubInterval);
                return projectImportResults;
            }
            finally {
                if (eventCont != null) {
                    eventCont.removeEvent(this.johnsonEvent);
                }
            }
        }

        @Override
        public void setTaskProgressSink(TaskProgressSink taskProgressSink) {
            this.taskProgressSink = new JohnsonUpdatingTaskProgressSink(this.johnsonEvent, taskProgressSink);
        }
    }

    private class ReMappingResultCallable
    implements Callable<MappingResult>,
    ProvidesTaskProgress {
        private TaskProgressSink taskProgressSink;
        private final ProjectImportOptions projectImportOptions;
        private final ProjectImportData projectImportData;
        private final BackupProject selectedProject;
        private final BackupSystemInformation backupSystemInformation;
        private final JiraServiceContext serviceContext;

        public ReMappingResultCallable(ProjectImportOptions projectImportOptions, ProjectImportData projectImportData, BackupProject selectedProject, BackupSystemInformation backupSystemInformation, JiraServiceContext serviceContext) {
            this.projectImportOptions = projectImportOptions;
            this.projectImportData = projectImportData;
            this.selectedProject = selectedProject;
            this.backupSystemInformation = backupSystemInformation;
            this.serviceContext = serviceContext;
        }

        @Override
        public MappingResult call() throws Exception {
            TaskProgressInterval taskProgressInterval = new TaskProgressInterval(this.taskProgressSink, 0, 100);
            return ProjectImportSummary.this.projectImportService.doMapping(this.serviceContext, this.projectImportOptions, this.projectImportData, this.selectedProject, this.backupSystemInformation, taskProgressInterval);
        }

        @Override
        public void setTaskProgressSink(TaskProgressSink taskProgressSink) {
            this.taskProgressSink = taskProgressSink;
        }
    }
}

