/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.filters;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.bc.filter.FilterSubscriptionService;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.action.admin.filters.AbstractAdministerFilter;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;

public class DeleteSharedFilter
extends AbstractAdministerFilter {
    private static final int FILTERS_PER_PAGE = 20;
    private final SearchRequestService searchRequestService;
    private final FilterSubscriptionService subscriptionService;
    private final FavouritesService favouriteService;
    private final SearchRequestManager searchRequestManager;
    private Long otherFavouriteCount;
    private Collection<GenericValue> subscriptions;

    public DeleteSharedFilter(IssueSearcherManager issueSearcherManager, SearchRequestService searchRequestService, FavouritesService favouriteService, SearchService searchService, SearchSortUtil searchSortUtil, FilterSubscriptionService subscriptionService, PermissionManager permissionManager, SearchRequestManager searchRequestManager) {
        super(issueSearcherManager, searchRequestService, favouriteService, searchService, searchSortUtil, subscriptionService, permissionManager, searchRequestManager);
        this.searchRequestService = searchRequestService;
        this.favouriteService = favouriteService;
        this.subscriptionService = subscriptionService;
        this.searchRequestManager = searchRequestManager;
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        JiraServiceContext ctx = this.getJiraServiceContext();
        if (this.getFilterId() != null) {
            this.searchRequestService.validateForDelete(ctx, this.getFilterId());
            if (this.hasAnyErrors()) {
                return "error";
            }
            this.searchRequestService.deleteFilter(this.getJiraServiceContext(this.getFilterId()), this.getFilterId());
            if (this.hasAnyErrors()) {
                return "error";
            }
        } else {
            this.addErrorMessage(this.getText("admin.errors.filters.cannot.delete.filter"));
            return "error";
        }
        this.setSearchRequest(null);
        this.repaginateIfNeeded();
        if (this.isInlineDialogMode()) {
            return this.returnCompleteWithInlineRedirect(this.buildReturnUri());
        }
        String returnUrl = this.buildReturnUri();
        this.setReturnUrl(null);
        return this.forceRedirect(returnUrl);
    }

    private void repaginateIfNeeded() {
        int newResultCount;
        int pagingOffset = StringUtils.isNotBlank((String)this.getPagingOffset()) ? Integer.parseInt(this.getPagingOffset()) - 1 : -1;
        int n = newResultCount = StringUtils.isNotBlank((String)this.getTotalResultCount()) ? Integer.parseInt(this.getTotalResultCount()) - 1 : -1;
        if (pagingOffset >= 0) {
            this.setTotalResultCount("" + newResultCount);
            if (newResultCount % 20 == 0) {
                this.setPagingOffset("" + pagingOffset);
            }
        }
    }

    public int getOtherFavouriteCount() {
        if (this.otherFavouriteCount == null) {
            SearchRequest request = this.getFilter();
            ApplicationUser filterOwner = this.searchRequestManager.getSearchRequestOwner(this.getFilterId());
            boolean isFavourite = this.favouriteService.isFavourite(filterOwner, (SharedEntity)request);
            int count = isFavourite ? request.getFavouriteCount().intValue() - 1 : request.getFavouriteCount().intValue();
            this.otherFavouriteCount = count;
        }
        return this.otherFavouriteCount.intValue();
    }

    public int getSubscriptionCount() {
        return this.getSubscriptions().size();
    }

    public Collection getSubscriptions() {
        if (this.subscriptions == null) {
            ApplicationUser filterOwner = this.searchRequestManager.getSearchRequestOwner(this.getFilterId());
            this.subscriptions = this.subscriptionService.getVisibleSubscriptions(filterOwner, this.getFilter());
        }
        return this.subscriptions;
    }

    public boolean canDelete() {
        return !this.hasAnyErrors();
    }
}

