/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.filters;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.bc.filter.FilterSubscriptionService;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.sharing.ShareTypeValidatorUtils;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.admin.filters.AbstractAdministerFilter;
import java.net.URI;
import org.apache.commons.lang.StringUtils;

public class ChangeSharedFilterOwner
extends AbstractAdministerFilter {
    private ApplicationUser ownerUserObj;
    private String owner;
    private String ownerError;
    private static final String FILTERNAME = "filterName";
    private final UserPickerSearchService userPickerSearchService;
    private final AvatarService avatarService;
    private final UserManager userManager;
    private final SearchRequestService searchRequestService;
    private final PermissionManager permissionManager;
    private final ShareTypeValidatorUtils shareTypeValidatorUtils;

    public ChangeSharedFilterOwner(IssueSearcherManager issueSearcherManager, SearchRequestService searchRequestService, FavouritesService favouriteService, SearchService searchService, SearchSortUtil searchSortUtil, FilterSubscriptionService subscriptionService, PermissionManager permissionManager, SearchRequestManager searchRequestManager, UserPickerSearchService userPickerSearchService, AvatarService avatarService, UserManager userManager, ShareTypeValidatorUtils shareTypeValidatorUtils) {
        super(issueSearcherManager, searchRequestService, favouriteService, searchService, searchSortUtil, subscriptionService, permissionManager, searchRequestManager);
        this.permissionManager = permissionManager;
        this.searchRequestService = searchRequestService;
        this.userPickerSearchService = userPickerSearchService;
        this.avatarService = avatarService;
        this.userManager = userManager;
        this.shareTypeValidatorUtils = shareTypeValidatorUtils;
    }

    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        JiraServiceContext ctx = this.getJiraServiceContext(this.owner);
        this.searchRequestService.validateFilterForChangeOwner(ctx, this.getFilter());
        this.addErrorCollection(this.convertDelegatedUserAndFilterNameErrorsToMessages(ctx.getErrorCollection()));
        if (this.hasAnyErrors()) {
            return "error";
        }
        this.searchRequestService.updateFilterOwner(ctx, this.getLoggedInApplicationUser(), this.getFilter());
        this.addErrorCollection(this.convertDelegatedUserAndFilterNameErrorsToMessages(ctx.getErrorCollection()));
        if (this.hasAnyErrors()) {
            return "error";
        }
        if (this.isInlineDialogMode()) {
            return this.returnCompleteWithInlineRedirect(this.buildReturnUri());
        }
        String returnUrl = this.buildReturnUri();
        this.setReturnUrl(null);
        return this.forceRedirect(returnUrl);
    }

    private ErrorCollection convertDelegatedUserAndFilterNameErrorsToMessages(ErrorCollection errorCollection) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        errors.addErrorMessages(errorCollection.getErrorMessages());
        String delegatedUserError = (String)errorCollection.getErrors().get("shares_delegated");
        String filterNameError = (String)errorCollection.getErrors().get(FILTERNAME);
        if (StringUtils.isNotBlank((String)delegatedUserError)) {
            errors.addErrorMessage(delegatedUserError);
        }
        if (StringUtils.isNotBlank((String)filterNameError)) {
            errors.addErrorMessage(filterNameError);
        }
        return errors;
    }

    protected void doValidation() {
        if (StringUtils.isBlank((String)this.ownerError)) {
            this.setOwnerError(null);
        }
        if (StringUtils.isBlank((String)this.owner)) {
            this.setOwnerError("");
            this.addError("owner", this.getText("sharedfilters.admin.filter.owner.empty"));
        } else {
            this.validateUserExists(this.owner);
        }
        if (!this.hasAnyErrors()) {
            JiraServiceContext serviceCtx = this.getJiraServiceContext(this.owner);
            this.getFilter().setOwner(this.userManager.getUserByName(this.owner));
            this.shareTypeValidatorUtils.isValidSharePermission(serviceCtx, (SharedEntity)this.getFilter());
            this.addErrorCollection(this.convertDelegatedUserAndFilterNameErrorsToMessages(serviceCtx.getErrorCollection()));
        }
    }

    public boolean canChangeOwner() {
        return !this.hasAnyErrors();
    }

    public boolean userPickerDisabled() {
        return !this.userPickerSearchService.canPerformAjaxSearch(this.getJiraServiceContext());
    }

    public ApplicationUser getOwnerUserObj() throws Exception {
        if (this.getOwner() != null && this.ownerUserObj == null) {
            this.ownerUserObj = this.userManager.getUserByName(this.owner);
        }
        return this.ownerUserObj;
    }

    public String getOwner() {
        SearchRequest filter = this.getFilter();
        return filter.getOwner() == null ? null : filter.getOwner().getUsername();
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    private void validateUserExists(String ownerUsername) {
        if (this.userManager.getUserByName(ownerUsername) == null) {
            this.addError("owner", this.getText("sharedfilters.admin.filter.owner.does.not.exist", ownerUsername));
            this.setOwnerError(ownerUsername);
        }
    }

    public URI getOwnerUserAvatarUrl() {
        return this.avatarService.getAvatarUrlNoPermCheck(this.getOwner(), Avatar.Size.SMALL);
    }

    public String getOwnerError() {
        return this.ownerError;
    }

    public void setOwnerError(String ownerError) {
        this.ownerError = ownerError;
    }

    private JiraServiceContext getJiraServiceContext(String owner) {
        Object ctx = this.permissionManager.hasPermission(0, this.getLoggedInUser()) ? new JiraServiceContextImpl(UserUtils.getUser((String)owner)) : this.getJiraServiceContext();
        return ctx;
    }
}

