/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.jira.admin.IntroductionProperty;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.setting.GzipCompression;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.jira.web.util.HelpUtil;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

@WebSudoRequired
public class ViewApplicationProperties
extends ProjectActionSupport {
    protected final UserPickerSearchService searchService;
    protected final LocaleManager localeManager;
    protected final TimeZoneService timeZoneService;
    protected final RendererManager rendererManager;
    private final PluginAccessor pluginAccessor;
    private final GzipCompression gZipCompression;
    private final IntroductionProperty introductionProperty;
    private final FeatureManager featureManager;
    private final JiraLicenseService jiraLicenseService;
    private boolean useGravatar;
    protected boolean disableInlineEdit;
    protected boolean criteriaAutoUpdate;
    private Boolean productRecommendations;
    private boolean analyticsBTFEnabled;
    private boolean analyticsConfigChanged = false;
    private boolean projectDescriptionHtmlEnabled;

    public ViewApplicationProperties(UserPickerSearchService searchService, LocaleManager localeManager, TimeZoneService timeZoneService, RendererManager rendererManager, PluginAccessor pluginAccessor, GzipCompression gZipCompression, FeatureManager featureManager, IntroductionProperty introductionProperty, JiraLicenseService jiraLicenseService) {
        this.searchService = searchService;
        this.localeManager = localeManager;
        this.timeZoneService = timeZoneService;
        this.rendererManager = rendererManager;
        this.pluginAccessor = pluginAccessor;
        this.gZipCompression = gZipCompression;
        this.featureManager = featureManager;
        this.introductionProperty = introductionProperty;
        this.jiraLicenseService = jiraLicenseService;
        this.useGravatar = this.getApplicationProperties().getOption("jira.user.avatar.gravatar.enabled");
        this.disableInlineEdit = this.getApplicationProperties().getOption("jira.issue.inline.edit.disabled");
        this.criteriaAutoUpdate = this.getApplicationProperties().getOption("jira.issuenav.criteria.autoupdate");
        this.analyticsBTFEnabled = this.getApplicationProperties().getOption("jira.btf.analytics.enabled");
        this.projectDescriptionHtmlEnabled = this.getApplicationProperties().getOption("jira.project.description.html.enabled");
    }

    public LocaleManager getLocaleManager() {
        return this.localeManager;
    }

    public String getJiraMode() {
        StringBuilder i18nString = new StringBuilder("admin.jira.mode.").append(this.getApplicationProperties().getString("jira.mode"));
        return this.getText(i18nString.toString());
    }

    public String getDisplayNameOfLocale(Locale locale) {
        return locale.getDisplayName(this.getLocale());
    }

    public boolean useSystemTimeZone() {
        return this.timeZoneService.useSystemTimeZone();
    }

    public TimeZoneInfo getDefaultTimeZoneInfo() {
        return this.timeZoneService.getDefaultTimeZoneInfo(this.getJiraServiceContext());
    }

    public boolean isUseGravatar() {
        return this.useGravatar;
    }

    public void setUseGravatar(boolean useGravatar) {
        this.useGravatar = useGravatar;
    }

    public String getContactAdministratorsMessage() {
        String message = this.getApplicationProperties().getDefaultBackedString("jira.contact.administrators.message");
        return this.rendererManager.getRendererForType("atlassian-wiki-renderer").render(message, null);
    }

    public boolean getShowPluginHints() {
        return this.getApplicationProperties().getOption("show.plugin.marketing.hints");
    }

    public String getTacUrl() {
        return HelpUtil.getInstance().getHelpPath("application.properties.server.language.from.tac").getUrl();
    }

    public boolean isDisableInlineEdit() {
        return this.disableInlineEdit;
    }

    public boolean isShowDisableInlineEdit() {
        return this.pluginAccessor.isPluginEnabled("com.atlassian.jira.jira-issue-nav-plugin");
    }

    public boolean isShowDisableCriteriaAutoUpdate() {
        return this.pluginAccessor.isPluginEnabled("com.atlassian.jira.jira-issue-nav-plugin");
    }

    public boolean isCriteriaAutoUpdate() {
        return this.criteriaAutoUpdate;
    }

    public final boolean isProductRecommendationsAvailable() {
        return this.featureManager.isOnDemand();
    }

    public final boolean isProductRecommendationsEditable() {
        return this.isEvaluationLicense();
    }

    public final boolean isProductRecommendations() {
        if (this.productRecommendations == null) {
            this.productRecommendations = this.featureManager.isOnDemand() && this.isEvaluationLicense() && !this.getApplicationProperties().getOption("jira.ads.disabled");
        }
        return this.productRecommendations;
    }

    public void setProductRecommendations(boolean productRecommendations) {
        this.productRecommendations = productRecommendations;
    }

    public final boolean isShowDisableAnalytics() {
        return !this.featureManager.isOnDemand();
    }

    public final boolean isShowProjectDescriptionHtmlEnabled() {
        return !this.featureManager.isOnDemand();
    }

    public final boolean isAnalyticsBTFEnabled() {
        return this.analyticsBTFEnabled;
    }

    public void setAnalyticsBTFEnabled(boolean analyticsBTFEnabled) {
        this.analyticsBTFEnabled = analyticsBTFEnabled;
    }

    public boolean isProjectDescriptionHtmlEnabled() {
        return this.projectDescriptionHtmlEnabled;
    }

    public void setProjectDescriptionHtmlEnabled(boolean projectDescriptionHtmlEnabled) {
        this.projectDescriptionHtmlEnabled = projectDescriptionHtmlEnabled;
    }

    public void setUsageStatsChanged(boolean statsChanged) {
        this.analyticsConfigChanged = statsChanged;
    }

    public boolean isUsageStatsChanged() {
        return this.analyticsConfigChanged;
    }

    public GzipCompression getGzipCompression() {
        return this.gZipCompression;
    }

    public IntroductionProperty getIntroductionProperty() {
        return this.introductionProperty;
    }

    public boolean isBackgroundIndexingAvailable() {
        return true;
    }

    private boolean isEvaluationLicense() {
        return this.jiraLicenseService.getLicense().isEvaluation();
    }

    public Map<String, String> getAllowedLanguages() {
        LinkedHashMap<String, String> allowedLanguages = new LinkedHashMap<String, String>();
        allowedLanguages.put("armenian", this.getText("admin.jira.allowed.language.armenian"));
        allowedLanguages.put("basque", this.getText("admin.jira.allowed.language.basque"));
        allowedLanguages.put("brazilian", this.getText("admin.jira.allowed.language.brazilian"));
        allowedLanguages.put("bulgarian", this.getText("admin.jira.allowed.language.bulgarian"));
        allowedLanguages.put("catalan", this.getText("admin.jira.allowed.language.catalan"));
        allowedLanguages.put("chinese", this.getText("admin.jira.allowed.language.chinese"));
        allowedLanguages.put("cjk", this.getText("admin.jira.allowed.language.cjk"));
        allowedLanguages.put("czech", this.getText("admin.jira.allowed.language.czech"));
        allowedLanguages.put("danish", this.getText("admin.jira.allowed.language.danish"));
        allowedLanguages.put("dutch", this.getText("admin.jira.allowed.language.dutch"));
        allowedLanguages.put("english", this.getText("admin.jira.allowed.language.english.aggressive.stemming"));
        allowedLanguages.put("english-moderate-stemming", this.getText("admin.jira.allowed.language.english.moderate.stemming"));
        allowedLanguages.put("english-minimal-stemming", this.getText("admin.jira.allowed.language.english.minimal.stemming"));
        allowedLanguages.put("finnish", this.getText("admin.jira.allowed.language.finnish"));
        allowedLanguages.put("french", this.getText("admin.jira.allowed.language.french"));
        allowedLanguages.put("german", this.getText("admin.jira.allowed.language.german"));
        allowedLanguages.put("greek", this.getText("admin.jira.allowed.language.greek"));
        allowedLanguages.put("hungarian", this.getText("admin.jira.allowed.language.hungarian"));
        allowedLanguages.put("italian", this.getText("admin.jira.allowed.language.italian"));
        allowedLanguages.put("norwegian", this.getText("admin.jira.allowed.language.norwegian"));
        allowedLanguages.put("portuguese", this.getText("admin.jira.allowed.language.portuguese"));
        allowedLanguages.put("romanian", this.getText("admin.jira.allowed.language.romanian"));
        allowedLanguages.put("russian", this.getText("admin.jira.allowed.language.russian"));
        allowedLanguages.put("spanish", this.getText("admin.jira.allowed.language.spanish"));
        allowedLanguages.put("swedish", this.getText("admin.jira.allowed.language.swedish"));
        allowedLanguages.put("thai", this.getText("admin.jira.allowed.language.thai"));
        allowedLanguages.put("other", this.getText("admin.jira.allowed.language.other"));
        return allowedLanguages;
    }

    public String getCurrentIndexingLanguageDescription() {
        return this.getAllowedLanguages().get(this.getApplicationProperties().getString("jira.i18n.language.index"));
    }
}

