/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.fugue.Option;
import com.atlassian.jira.permission.GlobalPermissionType;
import com.atlassian.jira.security.GlobalPermissionEntry;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.GlobalPermissionGroupAssociationUtil;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@WebSudoRequired
public class GlobalPermissions
extends ProjectActionSupport {
    private Map<String, String> globalPermTypes;
    private String groupName;
    private String globalPermType = "";
    private String action = "view";
    private final GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil;
    private final GlobalPermissionManager globalPermissionManager;
    private final UserUtil userUtil;
    private final GroupManager groupManager;
    private final Supplier<String> returnUnknownString = new Supplier<String>(){

        public String get() {
            return GlobalPermissions.this.getText("common.words.unknown");
        }
    };

    public GlobalPermissions(GlobalPermissionManager globalPermissionManager, GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil, UserUtil userUtil, GroupManager groupManager) {
        this.globalPermissionGroupAssociationUtil = globalPermissionGroupAssociationUtil;
        this.globalPermissionManager = globalPermissionManager;
        this.userUtil = userUtil;
        this.groupManager = groupManager;
    }

    public String doDefault() throws Exception {
        return "success";
    }

    public void doValidation() {
        if (StringUtils.isNotBlank((String)this.globalPermType)) {
            Option globalPermissionOpt = this.globalPermissionManager.getGlobalPermission(this.globalPermType);
            if (globalPermissionOpt.isEmpty()) {
                this.addError("globalPermType", this.getText("admin.errors.permissions.inexistent.permission"));
            } else {
                GlobalPermissionType globalPermissionType = (GlobalPermissionType)globalPermissionOpt.get();
                if (this.groupName != null) {
                    if (!"del".equals(this.action) && !"confirm".equals(this.action)) {
                        Group group = this.groupManager.getGroup(this.groupName);
                        if (group == null) {
                            this.addError("groupName", this.getText("admin.errors.permissions.inexistent.group", "'" + this.groupName + "'"));
                        }
                        if (this.globalPermType.equals("USE") && this.getAdministrativeGroups().contains(group)) {
                            this.addError("groupName", this.getText("admin.errors.permissions.group.notallowed.for.permission", this.groupName, this.getText(globalPermissionType.getNameI18nKey())));
                        }
                    } else {
                        Collection groupNames = this.globalPermissionManager.getGroupNames(globalPermissionType);
                        if (!groupNames.contains(this.groupName)) {
                            this.addErrorMessage(this.getText("admin.errors.permissions.delete.group.not.in.permission", this.groupName, this.getText(globalPermissionType.getNameI18nKey())));
                        }
                    }
                } else if (!globalPermissionType.isAnonymousAllowed() && "add".equals(this.action)) {
                    this.addError("groupName", this.getText("admin.errors.permissions.group.notallowed.for.permission", this.getText("admin.common.words.anyone"), this.getText(globalPermissionType.getNameI18nKey())));
                }
            }
            this.validateAdd();
            this.validateDelete();
        } else if ("add".equals(this.action)) {
            this.addError("globalPermType", this.getText("admin.errors.permissions.must.select.permission"));
        }
        super.doValidation();
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        Option globalPermissionOpt;
        if (StringUtils.isNotBlank((String)this.globalPermType) && (globalPermissionOpt = this.globalPermissionManager.getGlobalPermission(this.globalPermType)).isDefined()) {
            GlobalPermissionType globalPermissionType = (GlobalPermissionType)globalPermissionOpt.get();
            if ("del".equals(this.action)) {
                this.removePermission(globalPermissionType, this.groupName);
                this.action = "view";
                return this.getPermissionRedirect();
            }
            if ("confirm".equals(this.action)) {
                return "confirm";
            }
            if ("add".equals(this.action)) {
                Group group = this.groupName == null ? null : this.groupManager.getGroup(this.groupName);
                this.createPermission(globalPermissionType, group);
                return this.getPermissionRedirect();
            }
        }
        return this.getResult();
    }

    private void validateDelete() {
        if ("del".equals(this.action) || "confirm".equals(this.action)) {
            if (this.globalPermType.equals("ADMINISTER")) {
                boolean removingAllPerms;
                boolean bl = removingAllPerms = this.globalPermissionGroupAssociationUtil.isRemovingAllMyAdminGroups(EasyList.build((Object)this.groupName), this.getLoggedInApplicationUser().getDirectoryUser()) && !this.globalPermissionManager.hasPermission(44, this.getLoggedInApplicationUser());
                if (removingAllPerms) {
                    this.addErrorMessage(this.getText("admin.errors.permissions.no.permission"));
                }
            } else if (this.globalPermType.equals("SYSTEM_ADMIN")) {
                if (!this.globalPermissionManager.hasPermission(44, this.getLoggedInUser())) {
                    this.addErrorMessage(this.getText("admin.errors.permissions.no.permission.sys.admin.only"));
                } else if (this.globalPermissionGroupAssociationUtil.isRemovingAllMySysAdminGroups(EasyList.build((Object)this.groupName), this.getLoggedInUser())) {
                    this.addErrorMessage(this.getText("admin.errors.permissions.no.permission.sys.admin"));
                }
            }
        }
    }

    private void validateAdd() {
        if ("add".equals(this.action) && !this.getGlobalPermTypes().containsKey(this.globalPermType)) {
            this.addErrorMessage(this.getText("admin.errors.permissions.not.have.permission.to.add"));
        }
    }

    private String getPermissionRedirect() throws Exception {
        return this.getRedirect("GlobalPermissions!default.jspa");
    }

    private void createPermission(GlobalPermissionType globalPermissionType, Group group) {
        String groupName;
        String string = groupName = group == null ? null : group.getName();
        if (!this.globalPermissionManager.getGroupNames(globalPermissionType).contains(groupName)) {
            this.globalPermissionManager.addPermission(globalPermissionType, groupName);
        }
    }

    private void removePermission(GlobalPermissionType globalPermissionType, String groupName) {
        Group group = groupName == null ? null : this.groupManager.getGroup(groupName);
        String groupToDelete = null;
        if (group != null) {
            groupToDelete = group.getName();
        } else if (groupName != null) {
            groupToDelete = groupName;
        }
        this.globalPermissionManager.removePermission(globalPermissionType, groupToDelete);
    }

    public Collection<GlobalPermissionEntry> getPermissionGroups(String globalPermType) {
        Option globalPermissionOpt = this.globalPermissionManager.getGlobalPermission(globalPermType);
        if (globalPermissionOpt.isDefined()) {
            GlobalPermissionType globalPermissionType = (GlobalPermissionType)globalPermissionOpt.get();
            return this.globalPermissionManager.getPermissions(globalPermissionType);
        }
        return Lists.newArrayList();
    }

    public Collection getGroups() {
        return this.groupManager.getAllGroups();
    }

    public String getGlobalPermType() {
        return this.globalPermType;
    }

    public String getPermTypeName() {
        return (String)this.globalPermissionManager.getGlobalPermission(this.globalPermType).fold(this.returnUnknownString, (Function)new Function<GlobalPermissionType, String>(){

            public String apply(GlobalPermissionType globalPermissionType) {
                return GlobalPermissions.this.getText(globalPermissionType.getNameI18nKey());
            }
        });
    }

    public void setGlobalPermType(String globalPermType) {
        this.globalPermType = globalPermType;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = TextUtils.stringSet((String)groupName) ? groupName : null;
    }

    public void setAction(String action) {
        this.action = "del".equalsIgnoreCase(action) || "delete".equalsIgnoreCase(action) ? "del" : ("confirm".equalsIgnoreCase(action) ? "confirm" : "add");
    }

    public boolean isConfirm() {
        return "confirm".equalsIgnoreCase(this.action);
    }

    public Map<String, String> getGlobalPermTypes() {
        if (this.globalPermTypes == null) {
            this.globalPermTypes = new LinkedHashMap<String, String>();
            GlobalPermissionType sysAdminPermission = (GlobalPermissionType)this.globalPermissionManager.getGlobalPermission("SYSTEM_ADMIN").get();
            if (this.globalPermissionManager.hasPermission(sysAdminPermission, this.getLoggedInApplicationUser())) {
                this.globalPermTypes.put(sysAdminPermission.getKey(), this.getText(sysAdminPermission.getNameI18nKey()));
            }
            this.permissionMapHelper("ADMINISTER", this.globalPermTypes);
            this.permissionMapHelper("USE", this.globalPermTypes);
            this.permissionMapHelper("USER_PICKER", this.globalPermTypes);
            this.permissionMapHelper("CREATE_SHARED_OBJECTS", this.globalPermTypes);
            this.permissionMapHelper("MANAGE_GROUP_FILTER_SUBSCRIPTIONS", this.globalPermTypes);
            this.permissionMapHelper("BULK_CHANGE", this.globalPermTypes);
            for (GlobalPermissionType globalPermissionType : this.globalPermissionManager.getAllGlobalPermissions()) {
                if (this.globalPermTypes.containsKey(globalPermissionType.getKey()) || "SYSTEM_ADMIN".equals(globalPermissionType.getKey())) continue;
                this.globalPermTypes.put(globalPermissionType.getKey(), this.getText(globalPermissionType.getNameI18nKey()));
            }
        }
        return this.globalPermTypes;
    }

    private void permissionMapHelper(String globalPermType, Map<String, String> map) {
        Option permissionOpt = this.globalPermissionManager.getGlobalPermission(globalPermType);
        if (permissionOpt.isDefined()) {
            GlobalPermissionType permission = (GlobalPermissionType)permissionOpt.get();
            map.put(permission.getKey(), this.getText(permission.getNameI18nKey()));
        }
    }

    public String getDescription(String permType) {
        return (String)this.globalPermissionManager.getGlobalPermission(permType).fold(this.returnUnknownString, (Function)new Function<GlobalPermissionType, String>(){

            public String apply(GlobalPermissionType globalPermissionType) {
                return GlobalPermissions.this.getText(globalPermissionType.getDescriptionI18nKey());
            }
        });
    }

    public boolean hasExceededUserLimit() {
        return this.userUtil.hasExceededUserLimit();
    }

    private Collection<Group> getAdministrativeGroups() {
        ArrayList groups = new ArrayList(this.globalPermissionManager.getGroupsWithPermission(0));
        groups.addAll(this.globalPermissionManager.getGroupsWithPermission(44));
        return Collections.unmodifiableCollection(groups);
    }

    private static final class Actions {
        private static final String VIEW = "view";
        private static final String ADD = "add";
        private static final String DEL = "del";
        private static final String DELETE = "delete";
        private static final String CONFIRM = "confirm";

        private Actions() {
        }
    }
}

