/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bc.license.JiraLicenseUpdaterService;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.upgrade.BuildNumComparator;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.system.JiraSystemRestarter;
import com.atlassian.jira.web.action.ActionViewDataMappings;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.atlassian.jira.web.util.ExternalLinkUtilImpl;
import com.atlassian.jira.web.util.MetalResourcesManager;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import webwork.action.ServletActionContext;

public class ConfirmNewInstallationWithOldLicense
extends JiraWebActionSupport {
    private static final String CROWD_EMBEDDED_INTEGRATION_VERSION = "602";
    public static final String RADIO_OPTION_LICENSE = "license";
    public static final String RADIO_OPTION_EVALUATION = "evaluation";
    private final JiraLicenseUpdaterService jiraLicenseService;
    private final BuildUtilsInfo buildUtilsInfo;
    private final JiraSystemRestarter jiraSystemRestarter;
    private final CrowdService crowdService;
    private final PermissionManager permissionManager;
    private final JiraProperties jiraSystemProperties;
    private String userName;
    private String password;
    private String licenseString;
    private String radioOption;
    private boolean licenseUpdated = false;
    private boolean installationConfirmed = false;
    private LicenseDetails licenseDetails;
    private JiraLicenseService.ValidationResult validationResult;
    private boolean loginInvalid = false;
    private boolean radioOptionInvalid = false;

    public ConfirmNewInstallationWithOldLicense(JiraLicenseUpdaterService jiraLicenseService, BuildUtilsInfo buildUtilsInfo, JiraSystemRestarter jiraSystemRestarter, CrowdService crowdService, PermissionManager permissionManager, JiraProperties jiraSystemProperties) {
        this.crowdService = crowdService;
        this.permissionManager = permissionManager;
        this.jiraLicenseService = (JiraLicenseUpdaterService)Assertions.notNull((String)"jiraLicenseService", (Object)jiraLicenseService);
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.jiraSystemRestarter = (JiraSystemRestarter)Assertions.notNull((String)"jiraSystemRestarter", (Object)jiraSystemRestarter);
        this.jiraSystemProperties = jiraSystemProperties;
    }

    private boolean shouldDisplay() {
        return this.isPresentInJohnsonEventContainer(EventType.get((String)"license-too-old"));
    }

    private boolean isPresentInJohnsonEventContainer(EventType eventType) {
        final class IsEventOfType
        implements Predicate<Event> {
            private EventType eventType;

            IsEventOfType(EventType eventType) {
                this.eventType = eventType;
            }

            public boolean apply(@Nullable Event event) {
                return event != null && event.getKey().equals((Object)this.eventType);
            }
        }
        return Iterables.any((Iterable)this.getJohnsonEventContainer().getEvents(), (Predicate)new IsEventOfType(eventType));
    }

    public String doDefault() throws Exception {
        if (!this.shouldDisplay()) {
            return "securitybreach";
        }
        return "input";
    }

    protected void doValidation() {
        if (!this.shouldDisplay()) {
            return;
        }
        if (StringUtils.isBlank((String)this.radioOption)) {
            this.log.warn((Object)"Neither the License nor the Install Confirmation have been supplied.");
            this.addErrorMessage(this.getText("admin.errors.no.license"));
            this.setRadioOptionInvalid(true);
            return;
        }
        if (this.getUserInfoAvailable()) {
            boolean hasAdminPermission;
            User user = this.crowdService.getUser(this.userName);
            if (user == null) {
                this.addErrorMessage(this.getText("admin.errors.invalid.username.or.pasword"));
                this.setLoginInvalid(true);
                return;
            }
            try {
                this.crowdService.authenticate(this.userName, this.password);
            }
            catch (FailedAuthenticationException e) {
                this.addErrorMessage(this.getText("admin.errors.invalid.username.or.pasword"));
                this.setLoginInvalid(true);
                return;
            }
            if (!this.nonAdminUpgradeAllowed() && !(hasAdminPermission = this.permissionManager.hasPermission(0, user))) {
                this.addError("userName", this.getText("admin.errors.no.admin.permission"));
            }
        }
        if (this.radioOption.equals(RADIO_OPTION_LICENSE)) {
            this.validationResult = this.jiraLicenseService.validate((I18nHelper)this, this.licenseString);
            this.addErrorCollection(this.validationResult.getErrorCollection());
        }
    }

    protected String doExecute() throws Exception {
        if (!this.shouldDisplay()) {
            return "securitybreach";
        }
        if (this.radioOption.equals(RADIO_OPTION_LICENSE)) {
            this.licenseDetails = this.jiraLicenseService.setLicense(this.validationResult);
            if (!this.licenseDetails.isMaintenanceValidForBuildDate(this.buildUtilsInfo.getCurrentBuildDate())) {
                this.addError(RADIO_OPTION_LICENSE, this.getText("admin.errors.license.too.old"));
                return "error";
            }
            this.licenseUpdated = true;
        } else if (this.radioOption.equals(RADIO_OPTION_EVALUATION)) {
            this.jiraLicenseService.confirmProceedUnderEvaluationTerms(this.userName);
            this.installationConfirmed = true;
        } else {
            throw new IllegalStateException("This will never happen!");
        }
        this.jiraSystemRestarter.ariseSirJIRA();
        JohnsonEventContainer cont = JohnsonEventContainer.get((ServletContext)ServletActionContext.getServletContext());
        for (Object o : cont.getEvents()) {
            Event event = (Event)o;
            if (event == null || !event.getKey().equals((Object)EventType.get((String)"license-too-old"))) continue;
            cont.removeEvent(event);
        }
        cont.addEvent(new Event(EventType.get((String)"restart"), this.getText("system.error.restart.for.changes"), EventLevel.get((String)"fatal")));
        return "success";
    }

    JohnsonEventContainer getJohnsonEventContainer() {
        return JohnsonEventContainer.get((ServletContext)ServletActionContext.getServletContext());
    }

    public LicenseDetails getLicenseDetails() {
        if (this.licenseDetails == null) {
            this.licenseDetails = this.jiraLicenseService.getLicense();
        }
        return this.licenseDetails;
    }

    public Map<String, String> getLicenseStatusMessages() {
        LicenseDetails.LicenseStatusMessage licenseStatusMessage = this.getLicenseDetails().getLicenseStatusMessage(this.getI18nHelper());
        return licenseStatusMessage.getAllMessages();
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setLicense(String licenseString) {
        this.licenseString = licenseString;
    }

    public void setRadioOption(String radioOption) {
        this.radioOption = radioOption;
    }

    public void setLoginInvalid(boolean loginInvalid) {
        this.loginInvalid = loginInvalid;
    }

    public void setRadioOptionInvalid(boolean radioOptionInvalid) {
        this.radioOptionInvalid = radioOptionInvalid;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getLicense() {
        return this.licenseString;
    }

    public String getRadioOption() {
        return this.radioOption;
    }

    public boolean getLoginInvalid() {
        return this.loginInvalid;
    }

    public boolean getRadioOptionInvalid() {
        return this.radioOptionInvalid;
    }

    private boolean nonAdminUpgradeAllowed() {
        return this.jiraSystemProperties.getBoolean("non.admin.upgrade");
    }

    public BuildUtilsInfo getBuildUtilsInfo() {
        return this.buildUtilsInfo;
    }

    public String getCurrentBuildDate() {
        return this.getOutlookDate().formatDMY(this.buildUtilsInfo.getCurrentBuildDate());
    }

    public boolean getUserInfoAvailable() {
        BuildNumComparator comparator = new BuildNumComparator();
        if (comparator.compare(this.buildUtilsInfo.getCurrentBuildNumber(), CROWD_EMBEDDED_INTEGRATION_VERSION) < 0) {
            return true;
        }
        String currentDatabaseVersion = this.getApplicationProperties().getString("jira.version.patched");
        return !Strings.isNullOrEmpty((String)currentDatabaseVersion) && comparator.compare(currentDatabaseVersion, CROWD_EMBEDDED_INTEGRATION_VERSION) > 0;
    }

    @ActionViewDataMappings(value={"input", "error"})
    public Map<String, Object> getDataMap() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("serverId", this.getServerId());
        data.put("errors", this.getErrors());
        data.put("radioOption", this.getRadioOption());
        data.put("radioOptionLicense", RADIO_OPTION_LICENSE);
        data.put("radioOptionEvaluation", RADIO_OPTION_EVALUATION);
        String[] linkParams = new String[]{this.getBuildUtilsInfo().getVersion(), this.getBuildUtilsInfo().getCurrentBuildNumber(), "Enterprise", (String)data.get("serverId")};
        ExternalLinkUtil externalLinkUtil = ExternalLinkUtilImpl.getInstance();
        data.put("licenseDescLinkTag", "<a href=\"" + externalLinkUtil.getProperty("external.link.jira.license.view", linkParams) + "\">");
        String generalErrorMessage = this.getErrorMessages().isEmpty() ? null : (String)this.getErrorMessages().iterator().next();
        data.put("loginErrorMessageContent", this.getLoginInvalid() ? generalErrorMessage : null);
        data.put("radioOptionErrorMessageContent", this.getRadioOptionInvalid() ? generalErrorMessage : null);
        Map<String, String> licenseStatusMessages = this.getLicenseStatusMessages();
        if (licenseStatusMessages.get("admin.license.support.and.updates") != null) {
            data.put("licenseStatusMessage1Content", licenseStatusMessages.get("admin.license.support.and.updates"));
            data.put("licenseStatusMessage2Content", licenseStatusMessages.get("admin.license.renewal.target"));
        } else {
            data.put("licenseStatusMessage1Content", licenseStatusMessages.get("admin.license.evaluation"));
            data.put("licenseStatusMessage2Content", licenseStatusMessages.get("admin.license.evaluation.renew"));
        }
        data.put("userNameValue", this.getUserName());
        data.put("licenseValue", this.getLicense());
        data.put("jiraTitle", this.getApplicationProperties().getDefaultBackedString("jira.title"));
        data.put("jiraLogoUrl", this.getApplicationProperties().getDefaultBackedString("jira.lf.logo.url"));
        data.put("resourcesContent", MetalResourcesManager.getMetalResources(this.getHttpRequest().getContextPath()));
        return data;
    }

    @ActionViewDataMappings(value={"success"})
    public Map<String, Object> getDataMapSuccess() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("licenseUpdated", this.licenseUpdated);
        data.put("installationConfirmed", this.installationConfirmed);
        data.put("jiraTitle", this.getApplicationProperties().getDefaultBackedString("jira.title"));
        data.put("jiraLogoUrl", this.getApplicationProperties().getDefaultBackedString("jira.lf.logo.url"));
        data.put("resourcesContent", MetalResourcesManager.getMetalResources(this.getHttpRequest().getContextPath()));
        return data;
    }
}

