/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.thread;

import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.util.ImportUtils;
import com.atlassian.jira.util.searchers.ThreadLocalSearcherCache;
import com.atlassian.jira.web.filters.ThreadLocalQueryProfiler;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.TransactionUtil;

public class JiraThreadLocalUtils {
    public static void preCall() {
        JiraAuthenticationContextImpl.clearRequestCache();
        ThreadLocalQueryProfiler.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void postCall(Logger log, ProblemDeterminationCallback problemDeterminationCallback) {
        block10: {
            try {
                ThreadLocalQueryProfiler.end();
            }
            catch (IOException e) {
                log.error((Object)"Unable to call ThreadLocalQueryProfiler.end()", (Throwable)e);
            }
            ThreadLocalSearcherCache.resetSearchers();
            if (!ImportUtils.isIndexIssues()) {
                log.error((Object)"Indexing thread local not cleared. Clearing...");
                ImportUtils.setIndexIssues((boolean)true);
            }
            try {
                if (TransactionUtil.getLocalTransactionConnection() == null) break block10;
                try {
                    if (problemDeterminationCallback != null) {
                        problemDeterminationCallback.onOpenTransaction();
                    } else {
                        log.error((Object)"Uncommitted database transaction detected.  Closing...");
                    }
                }
                finally {
                    TransactionUtil.closeAndClearThreadLocalConnection();
                }
            }
            catch (Exception t) {
                log.error((Object)"Error while inspecting transaction thread local.", (Throwable)t);
            }
        }
    }

    public static interface ProblemDeterminationCallback {
        public void onOpenTransaction();
    }
}

