/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.system.check;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.util.system.check.I18nMessage;
import com.atlassian.jira.util.system.check.JvmVersionUtil;
import com.atlassian.jira.util.system.check.SystemEnvironmentCheck;
import com.atlassian.jira.util.system.check.SystemEnvironmentChecklist;
import com.atlassian.jira.web.util.HelpUtil;
import org.apache.log4j.Logger;

public class JVMCheck
implements SystemEnvironmentCheck {
    private static final Logger logger = Logger.getLogger((String)SystemEnvironmentChecklist.class.getName());
    private final JiraProperties jiraSystemProperties;
    private JvmVersionUtil jvmVersionUtil;

    public JVMCheck(JiraProperties jiraSystemProperties) {
        this.jiraSystemProperties = jiraSystemProperties;
        this.jvmVersionUtil = new JvmVersionUtil();
    }

    @Override
    public I18nMessage getWarningMessage() {
        String jvmVendor = this.jiraSystemProperties.getProperty("java.vm.vendor");
        if ("Sun Microsystems Inc.".equalsIgnoreCase(jvmVendor)) {
            return this.checkSunJVMVersion();
        }
        return null;
    }

    private I18nMessage checkSunJVMVersion() {
        String javaVersion = this.jiraSystemProperties.getProperty("java.version");
        if (javaVersion != null && javaVersion.startsWith("1.6.0")) {
            int jvmMinorVersion = this.jvmVersionUtil.getMinorVersion(javaVersion);
            if (jvmMinorVersion == -1) {
                logger.warn((Object)("Failed to determine JVM minor version. java.version='" + javaVersion + "'"));
            } else if (jvmMinorVersion < 18) {
                I18nMessage warning = new I18nMessage("admin.warning.jvmversion6");
                warning.addParameter(javaVersion);
                HelpUtil.HelpPath helpPath = HelpUtil.getInstance().getHelpPath("requirements");
                warning.setLink(helpPath.getUrl());
                return warning;
            }
        }
        return null;
    }
}

