/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.system.check;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.util.system.check.I18nMessage;
import com.atlassian.jira.util.system.check.JvmVersionUtil;
import com.atlassian.jira.util.system.check.SystemEnvironmentCheck;
import com.atlassian.jira.util.system.check.SystemEnvironmentChecklist;
import org.apache.log4j.Logger;

public class JRA18659Check
implements SystemEnvironmentCheck {
    private static final Logger logger = Logger.getLogger((String)SystemEnvironmentChecklist.class.getName());
    private final JvmVersionUtil jvmVersionUtil;
    private final JiraProperties jiraSystemProperties;

    public JRA18659Check(JiraProperties jiraSystemProperties) {
        this.jiraSystemProperties = jiraSystemProperties;
        this.jvmVersionUtil = new JvmVersionUtil();
    }

    @Override
    public I18nMessage getWarningMessage() {
        String jvmVersion = this.jiraSystemProperties.getProperty("java.vm.version");
        if (!this.checkJRA_18659(jvmVersion)) {
            I18nMessage message = new I18nMessage("admin.warning.jra_18659");
            message.addParameter(jvmVersion);
            return message;
        }
        return null;
    }

    private boolean checkJRA_18659(String jvmVersion) {
        if (jvmVersion.startsWith("1.5.0")) {
            int minorVersion = this.jvmVersionUtil.getMinorVersion(jvmVersion);
            int buildNumber = this.jvmVersionUtil.getBuildNumber(jvmVersion);
            if (minorVersion == -1) {
                logger.warn((Object)("Failed to determine JVM minor version. java.version='" + jvmVersion + "'"));
            } else {
                if (minorVersion < 18) {
                    return false;
                }
                if (minorVersion == 18) {
                    if (buildNumber == -1) {
                        logger.warn((Object)("Failed to determine JVM minor version. java.version='" + jvmVersion + "'"));
                    } else if (buildNumber < 3) {
                        return false;
                    }
                }
            }
        }
        return true;
    }
}

