/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.system;

import com.atlassian.jdk.utilities.runtimeinformation.MemoryInformation;
import com.atlassian.jdk.utilities.runtimeinformation.RuntimeInformation;
import com.atlassian.jdk.utilities.runtimeinformation.RuntimeInformationFactory;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import java.util.List;
import org.apache.log4j.Logger;

public class JiraRuntimeInformationFactory {
    private static final Logger log = Logger.getLogger(JiraRuntimeInformationFactory.class);
    private static final int MEGABYTE = 0x100000;

    public static RuntimeInformation getRuntimeInformation() {
        return RuntimeInformationFactory.getRuntimeInformation();
    }

    public static RuntimeInformation getRuntimeInformationInMegabytes() {
        return new DecoratedRuntimeInformation(JiraRuntimeInformationFactory.getRuntimeInformation());
    }

    static long inMegabytes(long bytes) {
        return bytes / 0x100000L;
    }

    static class MemoryInformationInMegabytes
    implements MemoryInformation {
        private final MemoryInformation info;

        public MemoryInformationInMegabytes(MemoryInformation info) {
            this.info = info;
        }

        public String getName() {
            return this.info.getName();
        }

        public long getTotal() {
            return Math.max(this.getUsed(), JiraRuntimeInformationFactory.inMegabytes(this.info.getTotal()));
        }

        public long getUsed() {
            try {
                return JiraRuntimeInformationFactory.inMegabytes(this.info.getUsed());
            }
            catch (RuntimeException e) {
                log.warn((Object)("Memory pool info returned by the java runtime is invalid for pool " + this.getName()));
                log.debug((Object)e.getMessage(), (Throwable)e);
                return -1L;
            }
        }

        public long getFree() {
            return this.getTotal() - this.getUsed();
        }
    }

    static class DecoratedRuntimeInformation
    implements RuntimeInformation {
        private final RuntimeInformation info;

        public DecoratedRuntimeInformation(RuntimeInformation info) {
            this.info = info;
        }

        public long getTotalHeapMemory() {
            return this.info.getTotalHeapMemory();
        }

        public long getTotalHeapMemoryUsed() {
            return this.info.getTotalHeapMemoryUsed();
        }

        public String getJvmInputArguments() {
            return this.info.getJvmInputArguments();
        }

        public List<MemoryInformation> getMemoryPoolInformation() {
            return CollectionUtil.transform((Iterable)this.info.getMemoryPoolInformation(), (Function)new Function<MemoryInformation, MemoryInformation>(){

                public MemoryInformation get(MemoryInformation input) {
                    return new MemoryInformationInMegabytes(input);
                }
            });
        }

        public long getTotalPermGenMemory() {
            return this.info.getTotalPermGenMemory();
        }

        public long getTotalPermGenMemoryUsed() {
            return this.info.getTotalPermGenMemoryUsed();
        }

        public long getTotalNonHeapMemory() {
            return this.info.getTotalNonHeapMemory();
        }

        public long getTotalNonHeapMemoryUsed() {
            return this.info.getTotalNonHeapMemoryUsed();
        }
    }
}

