/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.log;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RateLimitingLogger {
    private static final int MAX_STACK_TRACES = 25;
    private static final int MAX_IDLE_TIME = 5;
    private static final AtomicBoolean warningSuppressedMessageWritten = new AtomicBoolean(false);
    private static final AtomicLong lastWarning = new AtomicLong(0L);
    private static final AtomicInteger warningsLogged = new AtomicInteger(0);
    private final int maxStackTraces;
    private final long resetAfterMinutes;
    private final Logger delegate;
    private final String name;

    public RateLimitingLogger(Class clazz) {
        this(clazz, 25, 5);
    }

    public RateLimitingLogger(Class clazz, int maxStackTraces, int resetAfterMinutes) {
        this(Logger.getLogger((Class)clazz), maxStackTraces, resetAfterMinutes);
    }

    @VisibleForTesting
    RateLimitingLogger(Logger delegate, int maxStackTraces, int resetAfterMinutes) {
        this.delegate = delegate;
        this.name = delegate.getName();
        this.maxStackTraces = maxStackTraces;
        this.resetAfterMinutes = TimeUnit.MINUTES.toMillis(resetAfterMinutes);
    }

    public void trace(Object message) {
        this.delegate.trace(message);
    }

    public void trace(Object message, Throwable t) {
        this.delegate.trace(message, t);
    }

    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    public void debug(Object message) {
        this.delegate.debug(message);
    }

    public void debug(Object message, Throwable t) {
        this.delegate.debug(message, t);
    }

    public void error(Object message) {
        this.delegate.error(message);
    }

    public void error(Object message, Throwable t) {
        if (this.wantFullStackTrace()) {
            this.delegate.error(message, t);
        } else {
            this.delegate.error(message);
        }
    }

    public void fatal(Object message) {
        this.delegate.fatal(message);
    }

    public void fatal(Object message, Throwable t) {
        this.delegate.fatal(message, t);
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public boolean isEnabledFor(Priority level) {
        return this.delegate.isEnabledFor(level);
    }

    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    public void info(Object message) {
        this.delegate.info(message);
    }

    public void info(Object message, Throwable t) {
        this.delegate.info(message, t);
    }

    public void warn(Object message) {
        this.delegate.warn(message);
    }

    public void warn(Object message, Throwable t) {
        if (this.wantFullStackTrace()) {
            this.delegate.warn(message, t);
        } else {
            this.delegate.warn(message);
        }
    }

    private boolean wantFullStackTrace() {
        if (this.isDebugEnabled()) {
            return true;
        }
        if (System.currentTimeMillis() - lastWarning.get() > this.resetAfterMinutes) {
            warningsLogged.set(0);
            warningSuppressedMessageWritten.set(false);
        }
        lastWarning.set(System.currentTimeMillis());
        if (warningsLogged.incrementAndGet() <= this.maxStackTraces) {
            return true;
        }
        if (warningSuppressedMessageWritten.compareAndSet(false, true)) {
            this.delegate.warn((Object)"*******************************************************************************************************************");
            this.delegate.warn((Object)"Further indexing error stacktraces suppressed.");
            this.delegate.warn((Object)("To enable full stacktraces set logger level for '" + this.name + "' to 'DEBUG' "));
            this.delegate.warn((Object)"*******************************************************************************************************************");
        }
        return false;
    }

    @VisibleForTesting
    static void reset() {
        lastWarning.set(0L);
    }
}

