/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.IOUtils;

public class ZipUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream streamForZipFileEntry(File zipFile, String entryName) throws IOException {
        final ZipFile file = new ZipFile(zipFile.getAbsolutePath());
        InputStream underlyingStream = null;
        try {
            ZipArchiveEntry entry = file.getEntry(entryName);
            if (entry == null) {
                InputStream inputStream = null;
                return inputStream;
            }
            underlyingStream = file.getInputStream(entry);
        }
        finally {
            if (underlyingStream == null) {
                ZipFile.closeQuietly((ZipFile)file);
            }
        }
        return new FilterInputStream(underlyingStream){

            @Override
            public void close() throws IOException {
                super.close();
                file.close();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File inputDir, File output) throws IOException {
        if (!inputDir.exists()) {
            throw new FileNotFoundException(inputDir.getPath());
        }
        if (!output.exists()) {
            output.createNewFile();
        } else {
            if (output.isDirectory()) {
                throw new IOException("'" + output.getPath() + "' exists and is a directory. Cannot overwrite.");
            }
            if (!output.canWrite()) {
                throw new IOException("'" + output.getPath() + "' exists and is not writable.");
            }
        }
        ZipArchiveOutputStream out = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(output)));
        out.setLevel(-1);
        try {
            ZipUtils.compressDirectory(inputDir, out, "");
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compressDirectory(File inputDir, ZipArchiveOutputStream out, String parentPath) throws IOException {
        File[] files;
        for (File file : files = inputDir.listFiles()) {
            String name = parentPath + file.getName();
            ZipArchiveEntry archiveEntry = new ZipArchiveEntry(file, name);
            out.putArchiveEntry((ArchiveEntry)archiveEntry);
            if (file.isDirectory()) {
                ZipUtils.compressDirectory(file, out, archiveEntry.getName());
                continue;
            }
            FileInputStream input = new FileInputStream(file);
            try {
                IOUtils.copyLarge((InputStream)input, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
                out.closeArchiveEntry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File input, File outputDir) throws IOException {
        if (!input.exists()) {
            throw new FileNotFoundException(input.getPath());
        }
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        } else {
            if (!outputDir.isDirectory()) {
                throw new IOException("'" + outputDir.getPath() + "' exists but is not a directory. Cannot overwrite.");
            }
            if (!outputDir.canWrite()) {
                throw new IOException("'" + outputDir.getPath() + "' exists and is not writable.");
            }
        }
        ZipArchiveInputStream in = new ZipArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(input)));
        try {
            ZipArchiveEntry entry;
            do {
                if ((entry = in.getNextZipEntry()) == null || entry.isDirectory()) continue;
                String fileName = entry.getName();
                File file = new File(outputDir, fileName);
                file.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(file);
                try {
                    IOUtils.copyLarge((InputStream)in, (OutputStream)out);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)out);
                }
            } while (entry != null);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

