/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.scheduler.cron.ConversionResult;
import com.atlassian.jira.scheduler.cron.SimpleToCronTriggerConverter;
import java.text.ParseException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.quartz.CronTrigger;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class SimpleToCronUtil {
    private static final Logger log = Logger.getLogger(SimpleToCronUtil.class);
    private final Scheduler scheduler;
    private final SimpleToCronTriggerConverter simpleToCronTriggerConverter;

    public SimpleToCronUtil(Scheduler scheduler, SimpleToCronTriggerConverter simpleToCronTriggerConverter) {
        this.scheduler = scheduler;
        this.simpleToCronTriggerConverter = simpleToCronTriggerConverter;
    }

    public CronTrigger convertSimpleToCronTrigger(SimpleTrigger simpleTrigger) {
        CronTrigger result = null;
        try {
            ConversionResult conversionResult = this.convertToCronString(simpleTrigger);
            result = this.createCronTrigger(simpleTrigger, conversionResult);
        }
        catch (ParseException e) {
            log.error((Object)("Subscription with interval: " + simpleTrigger.getRepeatInterval() + " and nextFireTime: " + simpleTrigger.getNextFireTime() + " failed during parsing"), (Throwable)e);
            this.unscheduleJob((Trigger)simpleTrigger);
        }
        catch (SchedulerException e) {
            log.error((Object)("Un/Scheduling subscription failed with name: " + simpleTrigger.getName()), (Throwable)e);
        }
        return result;
    }

    public CronTrigger createCronTrigger(SimpleTrigger triggerFromSubscription, ConversionResult conversionResult) throws ParseException, SchedulerException {
        CronTrigger cronTrigger = new CronTrigger(triggerFromSubscription.getName(), triggerFromSubscription.getGroup(), triggerFromSubscription.getJobName(), triggerFromSubscription.getJobGroup(), conversionResult.cronString);
        Date nextFireTime = cronTrigger.getFireTimeAfter(null);
        if (nextFireTime == null) {
            throw new ParseException("CronTrigger [" + conversionResult.cronString + "] will never be run", 0);
        }
        this.unscheduleJob((Trigger)triggerFromSubscription);
        this.scheduler.scheduleJob((Trigger)cronTrigger);
        return cronTrigger;
    }

    public ConversionResult convertToCronString(SimpleTrigger triggerFromSubscription) {
        return this.simpleToCronTriggerConverter.convertToCronString(triggerFromSubscription.getNextFireTime(), triggerFromSubscription.getRepeatInterval());
    }

    public void unscheduleJob(Trigger triggerFromSubscription) {
        try {
            if (this.scheduler.getTrigger(triggerFromSubscription.getName(), triggerFromSubscription.getGroup()) != null) {
                this.scheduler.unscheduleJob(triggerFromSubscription.getName(), triggerFromSubscription.getGroup());
            }
        }
        catch (SchedulerException e) {
            log.error((Object)("Un/Scheduling subscription failed with name: " + triggerFromSubscription.getName()), (Throwable)e);
        }
    }

    public boolean pauseScheduler() {
        try {
            if (!this.scheduler.isShutdown() && !this.scheduler.isPaused()) {
                this.scheduler.pause();
                return true;
            }
        }
        catch (SchedulerException e) {
            log.warn((Object)"Unable to pause the scheduler before running the integrity checker", (Throwable)e);
        }
        return false;
    }

    public void restartScheduler(boolean restartScheduler) {
        try {
            if (restartScheduler) {
                this.scheduler.start();
            }
        }
        catch (SchedulerException e) {
            log.warn((Object)"Error restarting the scheduler after running the integrity checker.", (Throwable)e);
        }
    }
}

