/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.component.PicoContainerFactory;
import java.util.Collection;
import java.util.Collections;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public class JiraUtils {
    public static final String AM = "am";
    public static final String PM = "pm";

    public static boolean isPublicMode() {
        String signupMode = ComponentAccessor.getApplicationProperties().getString("jira.mode");
        boolean publicMode = signupMode == null || signupMode.equals("public");
        return publicMode && ComponentAccessor.getUserManager().hasWritableDirectory();
    }

    public static <T> T loadComponent(String className, Class<?> callingClass) throws ClassNotFoundException {
        Class componentClass = ClassLoaderUtils.loadClass((String)className, callingClass);
        return JiraUtils.loadComponent(componentClass);
    }

    public static <T> T loadComponent(String className, ClassLoader classLoader) throws ClassNotFoundException {
        Class componentClass = ClassLoaderUtils.loadClass((String)className, (ClassLoader)classLoader);
        return JiraUtils.loadComponent(componentClass);
    }

    public static <T> T loadComponent(Class<T> componentClass) {
        return JiraUtils.loadComponent(componentClass, Collections.<Object>emptyList());
    }

    public static <T> T loadComponent(Class<T> componentClass, Collection<Object> extraParameters) {
        if (componentClass.isAssignableFrom(Void.class)) {
            return null;
        }
        PicoContainer applicationContainer = ComponentManager.getInstance().getContainer();
        MutablePicoContainer tempContainer = PicoContainerFactory.defaultJIRAContainer(applicationContainer);
        for (Object parameter : extraParameters) {
            tempContainer.addComponent(parameter);
        }
        tempContainer.addComponent(componentClass);
        return componentClass.cast(tempContainer.getComponent(componentClass));
    }

    public static int get24HourTime(String meridianIndicator, int hours) {
        if (hours == 12) {
            if (AM.equalsIgnoreCase(meridianIndicator)) {
                return 0;
            }
            if (PM.equalsIgnoreCase(meridianIndicator)) {
                return 12;
            }
        }
        int onceMeridianAdjustment = PM.equalsIgnoreCase(meridianIndicator) ? 12 : 0;
        return hours + onceMeridianAdjustment;
    }

    public static boolean isSetup() {
        return ComponentAccessor.getApplicationProperties().getString("jira.setup") != null;
    }
}

