/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.util.BuildUtils;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.lang.Pair;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildUtilsInfoImpl
implements BuildUtilsInfo {
    private static final String BUILD_PROPERTIES_FILENAME = "jira-build.properties";
    private static final Logger logger = LoggerFactory.getLogger(BuildUtilsInfoImpl.class);
    private final Properties buildProperties;
    private final int applicationBuildNumber = Integer.parseInt(BuildUtils.getCurrentBuildNumber());

    public BuildUtilsInfoImpl() {
        this.buildProperties = this.loadProperties();
    }

    public String getVersion() {
        return BuildUtils.getVersion();
    }

    public int[] getVersionNumbers() {
        return (int[])BuildUtilsInfoImpl.parseVersion(this.getVersion()).first();
    }

    public String getCurrentBuildNumber() {
        return BuildUtils.getCurrentBuildNumber();
    }

    public int getApplicationBuildNumber() {
        return this.applicationBuildNumber;
    }

    public int getDatabaseBuildNumber() {
        String patchedVersion = ComponentAccessor.getApplicationProperties().getString("jira.version.patched");
        if (patchedVersion == null) {
            return 0;
        }
        return Integer.parseInt(patchedVersion);
    }

    public String getMinimumUpgradableBuildNumber() {
        return BuildUtils.getMinimumUpgradableBuildNumber();
    }

    public Date getCurrentBuildDate() {
        return BuildUtils.getCurrentBuildDate();
    }

    public String getBuildPartnerName() {
        return BuildUtils.getBuildPartnerName();
    }

    public String getBuildInformation() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getVersion());
        sb.append("#");
        sb.append(this.getCurrentBuildNumber());
        if (StringUtils.isNotBlank((String)this.getCommitId())) {
            sb.append("-sha1:").append(this.getCommitId());
        }
        if (StringUtils.isNotBlank((String)this.getBuildPartnerName())) {
            sb.append("-").append(this.getBuildPartnerName());
        }
        return sb.toString();
    }

    @Deprecated
    public String getSvnRevision() {
        return this.getCommitId();
    }

    public String getCommitId() {
        return BuildUtils.getCommitId();
    }

    public String getMinimumUpgradableVersion() {
        return BuildUtils.getMinimumUpgradableVersion();
    }

    public Collection<Locale> getUnavailableLocales() {
        return BuildUtils.getUnavailableLocales();
    }

    public String getSalVersion() {
        return this.buildProperties.getProperty("sal.version");
    }

    public String getApplinksVersion() {
        return this.buildProperties.getProperty("applinks.version");
    }

    public String getLuceneVersion() {
        return this.buildProperties.getProperty("lucene.version");
    }

    public String getGuavaOsgiVersion() {
        return this.buildProperties.getProperty("guava.osgi.version");
    }

    public String getBuildProperty(String key) {
        return this.buildProperties.getProperty(key);
    }

    public boolean isBeta() {
        return ((String)BuildUtilsInfoImpl.parseVersion(this.getVersion()).second()).toLowerCase().startsWith("-beta");
    }

    public boolean isRc() {
        return ((String)BuildUtilsInfoImpl.parseVersion(this.getVersion()).second()).toLowerCase().startsWith("-rc");
    }

    public boolean isSnapshot() {
        return ((String)BuildUtilsInfoImpl.parseVersion(this.getVersion()).second()).toUpperCase().startsWith("-SNAPSHOT");
    }

    public boolean isMilestone() {
        return ((String)BuildUtilsInfoImpl.parseVersion(this.getVersion()).second()).toLowerCase().startsWith("-m");
    }

    public String toString() {
        return this.getBuildInformation();
    }

    private Properties loadProperties() throws RuntimeException {
        InputStream propsFile = BuildUtilsInfoImpl.class.getResourceAsStream("/jira-build.properties");
        if (propsFile == null) {
            throw new IllegalStateException("File not found: jira-build.properties");
        }
        Properties result = new Properties();
        try {
            result.load(propsFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                propsFile.close();
            }
            catch (IOException e) {
                logger.warn("Error closing {}", (Object)propsFile);
            }
        }
        return result;
    }

    static Pair<int[], String> parseVersion(String version) {
        LinkedList<Integer> ints = new LinkedList<Integer>();
        Matcher m = Pattern.compile("([0-9]+)(\\.?)(.*)").matcher("");
        String rest = version;
        while (m.reset(rest).matches()) {
            String i = m.group(1);
            ints.add(Integer.parseInt(i));
            String dot = m.group(2);
            rest = m.group(3);
            if (".".equals(dot)) continue;
            break;
        }
        while (ints.size() < 3) {
            ints.add(0);
        }
        return Pair.of((Object)Ints.toArray(ints), (Object)rest);
    }
}

