/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.ApplicationUserEntity;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.map.CacheObject;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericValue;

public class UserKeyStoreImpl
implements UserKeyStore {
    private static final String USER_KEY = "userKey";
    private static final String LOWER_USER_NAME = "lowerUserName";
    private final EntityEngine entityEngine;
    private final OfBizDelegator ofBizDelegator;
    private final DelegatorInterface delegatorInterface;
    private final Cache<LazyCacheKey, CacheObject<String>> keyToUsernameCache;
    private final Cache<LazyCacheKey, CacheObject<String>> usernameToKeyCache;
    private final Cache<String, CacheObject<Long>> userkeyToIdCache;

    public UserKeyStoreImpl(EntityEngine entityEngine, OfBizDelegator ofBizDelegator, DelegatorInterface delegatorInterface, EventPublisher eventPublisher, CacheManager cacheManager) {
        this.entityEngine = entityEngine;
        this.ofBizDelegator = ofBizDelegator;
        this.delegatorInterface = delegatorInterface;
        this.keyToUsernameCache = cacheManager.getCache(UserKeyStoreImpl.class.getName() + ".keyToUsernameCache", (CacheLoader)new KeyToNameCacheLoader());
        this.usernameToKeyCache = cacheManager.getCache(UserKeyStoreImpl.class.getName() + ".usernameToKeyCache", (CacheLoader)new NameToKeyCacheLoader());
        this.userkeyToIdCache = cacheManager.getCache(UserKeyStoreImpl.class.getName() + ".userkeyToIdCache", (CacheLoader)new KeyToIdCacheLoader());
        this.buildCache();
        eventPublisher.register((Object)this);
    }

    @Override
    public String getUsernameForKey(String key) {
        if (key == null) {
            return null;
        }
        return (String)((CacheObject)this.keyToUsernameCache.get((Object)new LazyCacheKey(key))).getValue();
    }

    @Override
    public String getKeyForUsername(String username) {
        if (username == null) {
            return null;
        }
        username = IdentifierUtils.toLowerCase((String)username);
        return (String)((CacheObject)this.usernameToKeyCache.get((Object)new LazyCacheKey(username))).getValue();
    }

    @Override
    public Long getIdForUserKey(String userkey) {
        if (userkey == null) {
            return null;
        }
        return (Long)((CacheObject)this.userkeyToIdCache.get((Object)userkey)).getValue();
    }

    @Override
    public void renameUser(String oldUsername, String newUsername) {
        oldUsername = IdentifierUtils.toLowerCase((String)oldUsername);
        newUsername = IdentifierUtils.toLowerCase((String)newUsername);
        String key = (String)Select.stringColumn(USER_KEY).from(Entity.APPLICATION_USER).whereEqual(LOWER_USER_NAME, oldUsername).runWith(this.ofBizDelegator).singleValue();
        if (key == null) {
            throw new IllegalStateException("Trying to rename user '" + oldUsername + "' but no user key is mapped.");
        }
        this.entityEngine.execute(Update.into(Entity.APPLICATION_USER).set(LOWER_USER_NAME, newUsername).whereEqual(USER_KEY, key));
        this.usernameToKeyCache.remove((Object)new LazyCacheKey(oldUsername));
        this.usernameToKeyCache.remove((Object)new LazyCacheKey(newUsername));
        this.keyToUsernameCache.remove((Object)new LazyCacheKey(key));
        this.userkeyToIdCache.remove((Object)key);
    }

    @Override
    public String ensureUniqueKeyForNewUser(String username) {
        String lowerUsername = IdentifierUtils.toLowerCase((String)((String)Assertions.notNull((String)"username", (Object)username)));
        ApplicationUserEntity applicationUserEntity = (ApplicationUserEntity)Select.from(Entity.APPLICATION_USER).whereEqual(LOWER_USER_NAME, lowerUsername).runWith(this.entityEngine).singleValue();
        if (applicationUserEntity != null) {
            return applicationUserEntity.getKey();
        }
        applicationUserEntity = (ApplicationUserEntity)Select.from(Entity.APPLICATION_USER).whereEqual(USER_KEY, lowerUsername).runWith(this.entityEngine).singleValue();
        if (applicationUserEntity == null) {
            FieldMap fieldValues = FieldMap.build((String)USER_KEY, (Object)lowerUsername).add(LOWER_USER_NAME, (Object)lowerUsername);
            GenericValue newGV = this.ofBizDelegator.createValue(Entity.APPLICATION_USER.getEntityName(), (Map)fieldValues);
            this.usernameToKeyCache.remove((Object)new LazyCacheKey(lowerUsername));
            this.keyToUsernameCache.remove((Object)new LazyCacheKey(lowerUsername));
            this.userkeyToIdCache.remove((Object)lowerUsername);
            return lowerUsername;
        }
        Long id = this.delegatorInterface.getNextSeqId(Entity.APPLICATION_USER.getEntityName());
        String userkey = "ID" + id;
        FieldMap fieldValues = FieldMap.build((String)"id", (Object)id).add(USER_KEY, (Object)userkey).add(LOWER_USER_NAME, (Object)lowerUsername);
        this.ofBizDelegator.createValue(Entity.APPLICATION_USER.getEntityName(), (Map)fieldValues);
        this.usernameToKeyCache.remove((Object)new LazyCacheKey(lowerUsername));
        this.keyToUsernameCache.remove((Object)new LazyCacheKey(userkey));
        this.userkeyToIdCache.remove((Object)userkey);
        return userkey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String removeByKey(String key) {
        if (key == null) {
            return null;
        }
        try {
            ApplicationUserEntity user = (ApplicationUserEntity)Select.from(Entity.APPLICATION_USER).whereEqual(USER_KEY, key).runWith(this.entityEngine).singleValue();
            if (user != null) {
                Delete.from(Entity.APPLICATION_USER).whereEqual(USER_KEY, key).execute(this.entityEngine);
                this.usernameToKeyCache.remove((Object)new LazyCacheKey(user.getUsername()));
                String string = user.getUsername();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.userkeyToIdCache.remove((Object)key);
            this.keyToUsernameCache.remove((Object)new LazyCacheKey(key));
        }
    }

    private void buildCache() {
        List users = Select.from(Entity.APPLICATION_USER).runWith(this.entityEngine).asList();
        for (ApplicationUserEntity user : users) {
            this.keyToUsernameCache.get((Object)new LazyCacheKey(user.getKey(), user.getUsername()));
            this.usernameToKeyCache.get((Object)new LazyCacheKey(user.getUsername(), user.getKey()));
        }
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.keyToUsernameCache.removeAll();
        this.usernameToKeyCache.removeAll();
        this.userkeyToIdCache.removeAll();
        this.buildCache();
    }

    private class KeyToIdCacheLoader
    implements CacheLoader<String, CacheObject<Long>> {
        private KeyToIdCacheLoader() {
        }

        public CacheObject<Long> load(@Nonnull String key) {
            ApplicationUserEntity user = (ApplicationUserEntity)Select.from(Entity.APPLICATION_USER).whereEqual(UserKeyStoreImpl.USER_KEY, key).runWith(UserKeyStoreImpl.this.entityEngine).singleValue();
            return user == null ? CacheObject.NULL() : CacheObject.wrap(user.getId());
        }
    }

    private class NameToKeyCacheLoader
    implements CacheLoader<LazyCacheKey, CacheObject<String>> {
        private NameToKeyCacheLoader() {
        }

        public CacheObject<String> load(@Nonnull LazyCacheKey key) {
            if (key.value != null) {
                return CacheObject.wrap(key.value);
            }
            ApplicationUserEntity user = (ApplicationUserEntity)Select.from(Entity.APPLICATION_USER).whereEqual(UserKeyStoreImpl.LOWER_USER_NAME, key.key).runWith(UserKeyStoreImpl.this.entityEngine).singleValue();
            return user == null ? CacheObject.NULL() : CacheObject.wrap(user.getKey());
        }
    }

    private class KeyToNameCacheLoader
    implements CacheLoader<LazyCacheKey, CacheObject<String>> {
        private KeyToNameCacheLoader() {
        }

        public CacheObject<String> load(@Nonnull LazyCacheKey key) {
            if (key.value != null) {
                return CacheObject.wrap(key.value);
            }
            ApplicationUserEntity user = (ApplicationUserEntity)Select.from(Entity.APPLICATION_USER).whereEqual(UserKeyStoreImpl.USER_KEY, key.key).runWith(UserKeyStoreImpl.this.entityEngine).singleValue();
            return user == null ? CacheObject.NULL() : CacheObject.wrap(user.getUsername());
        }
    }

    private class LazyCacheKey
    implements Serializable {
        final String key;
        final String value;

        private LazyCacheKey(@Nullable String key, String value) {
            this.key = key;
            this.value = value;
        }

        private LazyCacheKey(String key) {
            this.key = key;
            this.value = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LazyCacheKey that = (LazyCacheKey)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

