/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.preferences;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.atlassian.jira.user.preferences.JiraUserPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.user.util.UserManager;

@EventComponent
public class DefaultUserPreferencesManager
implements UserPreferencesManager {
    private final Cache<String, JiraUserPreferences> cache;
    private final UserManager userManager;
    private final UserPropertyManager userPropertyManager;

    public DefaultUserPreferencesManager(UserManager userManager, UserPropertyManager userPropertyManager, CacheManager cacheManager) {
        this.userManager = userManager;
        this.userPropertyManager = userPropertyManager;
        this.cache = cacheManager.getCache(DefaultUserPreferencesManager.class.getName() + ".cache", (CacheLoader)new UserPreferencesCacheLoader(), new CacheSettingsBuilder().maxEntries(1000).build());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearCache();
    }

    public ExtendedPreferences getExtendedPreferences(ApplicationUser user) {
        if (user == null) {
            return new JiraUserPreferences((ApplicationUser)null);
        }
        return (ExtendedPreferences)this.cache.get((Object)user.getKey());
    }

    public Preferences getPreferences(ApplicationUser user) {
        return this.getExtendedPreferences(user);
    }

    public Preferences getPreferences(User user) {
        if (user == null) {
            return new JiraUserPreferences((User)null);
        }
        String userkey = ApplicationUsers.getKeyFor((User)user);
        return (Preferences)this.cache.get((Object)userkey);
    }

    public void clearCache() {
        this.cache.removeAll();
        this.userPropertyManager.clearCache();
    }

    public void clearCache(ApplicationUser user) {
        if (user != null) {
            this.clearCacheByKey(user.getKey());
        }
    }

    public void clearCacheByKey(String userKey) {
        if (userKey != null) {
            this.cache.remove((Object)userKey);
            this.userPropertyManager.clearCacheByKey(userKey);
        }
    }

    private class UserPreferencesCacheLoader
    implements CacheLoader<String, JiraUserPreferences> {
        private UserPreferencesCacheLoader() {
        }

        public JiraUserPreferences load(String userkey) {
            return new JiraUserPreferences(DefaultUserPreferencesManager.this.userManager.getUserByKey(userkey));
        }
    }
}

