/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.ofbiz.DefaultOfBizConnectionFactory;
import com.atlassian.jira.ofbiz.OfBizConnectionFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.user.util.UserKeyStoreImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

@EventComponent
public class DefaultUserPropertyManager
implements UserPropertyManager,
Startable {
    protected final Cache<String, PropertySet> psCache;
    private static final String ENTITY_TYPE = "ApplicationUser";
    private final UserKeyStore userKeyStore;
    private final OfBizConnectionFactory ofBizConnectionFactory;

    public DefaultUserPropertyManager(UserKeyStore userKeyStore, CacheManager cacheManager) {
        this.userKeyStore = userKeyStore;
        this.ofBizConnectionFactory = DefaultOfBizConnectionFactory.getInstance();
        this.psCache = cacheManager.getCache(DefaultUserPropertyManager.class.getName() + ".psCache", (CacheLoader)new PropertySetLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).maxEntries(500).build());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.psCache.removeAll();
        ((UserKeyStoreImpl)ComponentAccessor.getComponent(UserKeyStore.class)).onClearCache(null);
    }

    public void start() throws Exception {
    }

    public PropertySet getPropertySet(ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        return this.getPropertySetForUserKey(user.getKey());
    }

    public PropertySet getPropertySet(User user) {
        Assertions.notNull((String)"user", (Object)user);
        return this.getPropertySetForUserKey(this.userKeyStore.getKeyForUsername(user.getName()));
    }

    private PropertySet getPropertySetForUserKey(String userkey) {
        if (userkey == null) {
            return null;
        }
        return (PropertySet)this.psCache.get((Object)userkey);
    }

    public void clearCache() {
        this.psCache.removeAll();
    }

    public void clearCache(ApplicationUser user) {
        if (user != null) {
            this.psCache.remove((Object)user.getKey());
        }
    }

    public void clearCacheByKey(String userKey) {
        if (userKey != null) {
            this.psCache.remove((Object)userKey);
        }
    }

    private class PropertySetLoader
    implements CacheLoader<String, PropertySet> {
        private PropertySetLoader() {
        }

        public PropertySet load(String userkey) {
            Long id = DefaultUserPropertyManager.this.userKeyStore.getIdForUserKey(userkey);
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("entityId", id);
            args.put("entityName", DefaultUserPropertyManager.ENTITY_TYPE);
            args.put("delegator.name", DefaultUserPropertyManager.this.ofBizConnectionFactory.getDelegatorName());
            PropertySet basePs = PropertySetManager.getInstance((String)"ofbiz", args);
            args.clear();
            args.put("PropertySet", basePs);
            return PropertySetManager.getInstance((String)"cached", args);
        }
    }
}

