/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.user.SecureUserTokenManager;
import com.atlassian.security.random.DefaultSecureTokenGenerator;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

@EventComponent
public class DefaultSecureUserTokenManager
implements SecureUserTokenManager {
    final Cache<TokenKey, User> tokenCache;

    public DefaultSecureUserTokenManager(CacheManager cacheManager) {
        this.tokenCache = cacheManager.getCache(DefaultSecureUserTokenManager.class.getName() + ".tokenCache", null, new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    @Override
    public String generateToken(User user, SecureUserTokenManager.TokenType tokenType) {
        if (user == null) {
            return null;
        }
        String token = DefaultSecureTokenGenerator.getInstance().generateToken();
        this.tokenCache.put((Object)new TokenKey(token, tokenType), (Object)user);
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User useToken(String token, SecureUserTokenManager.TokenType tokenType) {
        TokenKey tokenKey = new TokenKey(token, tokenType);
        try {
            User user = (User)this.tokenCache.get((Object)tokenKey);
            return user;
        }
        finally {
            this.tokenCache.remove((Object)tokenKey);
        }
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.tokenCache.removeAll();
    }

    private static class TokenKey
    implements Serializable {
        private final String token;
        private final SecureUserTokenManager.TokenType tokenType;

        private TokenKey(String token, SecureUserTokenManager.TokenType tokenType) {
            this.token = token;
            this.tokenType = tokenType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TokenKey tokenKey = (TokenKey)o;
            if (this.token != null ? !this.token.equals(tokenKey.token) : tokenKey.token != null) {
                return false;
            }
            return this.tokenType == tokenKey.tokenType;
        }

        public int hashCode() {
            int result = this.token != null ? this.token.hashCode() : 0;
            result = 31 * result + this.tokenType.hashCode();
            return result;
        }

        public String toString() {
            return this.token + "," + (Object)((Object)this.tokenType);
        }
    }
}

