/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilMisc;

public class UpgradeTask_Build849
extends AbstractUpgradeTask {
    public static final String JIRA_CLONE_LINK_LEGACY_DIRECTION = "jira.clone.link.legacy.direction";
    public static final int BOOLEAN = 1;
    public static final int JIRA_PROPERTIES = 1;
    private final EntityEngine entityEngine;
    private final OfBizDelegator ofBizDelegator;

    public UpgradeTask_Build849(EntityEngine entityEngine, OfBizDelegator ofBizDelegator) {
        super(false);
        this.entityEngine = entityEngine;
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public String getBuildNumber() {
        return "849";
    }

    @Override
    public String getShortDescription() {
        return "Checks whether the clone link descriptions have been modified, and sets the jira.clone.link.legacy.direction flag to true if they have.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        if (this.cloneLinkDirectionsRenamed()) {
            this.setLegacyCloneDirectionProperty(true);
        } else {
            this.setLegacyCloneDirectionProperty(false);
        }
    }

    private boolean cloneLinkDirectionsRenamed() {
        Select.WhereContext<GenericValue> query = Select.from("IssueLinkType").whereEqual("linkname", "Cloners");
        List<GenericValue> clonersList = this.entityEngine.run(query).asList();
        if (clonersList.isEmpty()) {
            return false;
        }
        GenericValue clonersEntry = clonersList.iterator().next();
        return !clonersEntry.getString("inward").trim().toLowerCase().equals("is cloned by") && !clonersEntry.getString("outward").trim().toLowerCase().equals("clones");
    }

    private void setLegacyCloneDirectionProperty(boolean on) {
        GenericValue propertyEntry = this.ofBizDelegator.createValue("OSPropertyEntry", UtilMisc.toMap((String)"entityId", (Object)1, (String)"entityName", (Object)"jira.properties", (String)"type", (Object)1, (String)"propertyKey", (Object)JIRA_CLONE_LINK_LEGACY_DIRECTION));
        this.ofBizDelegator.createValue("OSPropertyNumber", UtilMisc.toMap((String)"id", (Object)propertyEntry.getLong("id"), (String)"value", (Object)(on ? 1 : 0)));
    }
}

