/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.PrimitiveMap;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build753
extends AbstractUpgradeTask {
    private static final Logger LOG = Logger.getLogger(UpgradeTask_Build753.class);
    private final OfBizDelegator delegator;

    public UpgradeTask_Build753(OfBizDelegator delegator) {
        super(false);
        this.delegator = delegator;
    }

    @Override
    public String getBuildNumber() {
        return "753";
    }

    @Override
    public void doUpgrade(boolean setupMode) {
        List gvs = this.delegator.findAll("FavouriteAssociations");
        if (gvs == null || gvs.isEmpty()) {
            return;
        }
        LOG.info((Object)String.format("Analysing %d Favourite Associations...", gvs.size()));
        for (GenericValue gv : gvs) {
            String lowercase_username;
            String username = gv.getString("username");
            if (username == null || username.equals(lowercase_username = IdentifierUtils.toLowerCase((String)username))) continue;
            this.delegator.removeValue(gv);
            Map<String, Object> lowercaseFind = new PrimitiveMap.Builder().add("entityType", gv.getString("entityType")).add("username", lowercase_username).add("entityId", gv.getLong("entityId")).toMap();
            List lowercaseGvs = this.delegator.findByAnd("FavouriteAssociations", lowercaseFind);
            if (lowercaseGvs == null || lowercaseGvs.size() == 0) {
                Collection<Long> previousEntities = this.getFavouriteIds(lowercase_username, gv.getString("entityType"));
                this.delegator.createValue("FavouriteAssociations", new PrimitiveMap.Builder().add("username", lowercase_username).add("entityType", gv.getString("entityType")).add("entityId", gv.getLong("entityId")).add("sequence", Long.valueOf(previousEntities.size())).toMap());
                continue;
            }
            this.decrementFavCount(gv);
        }
    }

    private void decrementFavCount(GenericValue gv) {
        Long id = gv.getLong("entityId");
        if (id == null) {
            return;
        }
        String type = gv.getString("entityType");
        if ("SearchRequest".equalsIgnoreCase(type) || "PortalPage".equalsIgnoreCase(type)) {
            Long count;
            GenericValue sharedEntity = this.delegator.findByPrimaryKey(type, id);
            if (sharedEntity != null && ((count = sharedEntity.getLong("favCount")) == null || count > 0L)) {
                count = count == null ? 0L : count - 1L;
                sharedEntity.set("favCount", (Object)count);
                this.delegator.store(sharedEntity);
            }
        } else {
            LOG.warn((Object)("Unable to update the favourite count for entity of type '" + type + "'."));
        }
    }

    private Collection<Long> getFavouriteIds(String username, String entityType) {
        List<GenericValue> idGVs = this.getFavouriteGVsOfEntityType(username, entityType, Lists.newArrayList((Object[])new String[]{"entityId"}));
        ArrayList<Long> ids = new ArrayList<Long>(idGVs.size());
        for (GenericValue genericValue : idGVs) {
            ids.add(genericValue.getLong("entityId"));
        }
        return Collections.unmodifiableList(ids);
    }

    private List<GenericValue> getFavouriteGVsOfEntityType(String username, String entityType, List<String> fieldToReturnList) {
        EntityExpr userCondition = new EntityExpr("username", EntityOperator.EQUALS, (Object)username);
        EntityExpr typeCondition = new EntityExpr("entityType", EntityOperator.EQUALS, (Object)entityType);
        EntityConditionList joinedCondition = new EntityConditionList((List)Lists.newArrayList((Object[])new EntityCondition[]{userCondition, typeCondition}), EntityOperator.AND);
        ArrayList orderByList = Lists.newArrayList((Object[])new String[]{"sequence ASC"});
        return this.delegator.findByCondition("FavouriteAssociations", (EntityCondition)joinedCondition, fieldToReturnList, (List)orderByList);
    }

    @Override
    public String getShortDescription() {
        return "Making the owner of favourites lowercase";
    }

    private static final class Order {
        private static final String ASCENDING = " ASC";

        private Order() {
        }
    }

    private static final class Column {
        private static final String ENTITY_ID = "entityId";
        private static final String USERNAME = "username";
        private static final String ENTITY_TYPE = "entityType";
        private static final String SEQUENCE = "sequence";
        private static final String FAV_COUNT = "favCount";

        private Column() {
        }
    }

    private static final class Table {
        static final String FAVOURITE_ASSOCIATION = "FavouriteAssociations";
        static final String SEARCH_REQUEST = "SearchRequest";
        static final String PORTAL_PAGE = "PortalPage";

        private Table() {
        }
    }
}

