/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.upgrade.tasks.DropIndexTask;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.jdbc.DatabaseUtil;
import org.ofbiz.core.entity.model.ModelEntity;

public class UpgradeTask_Build6256
extends DropIndexTask {
    public static final String AUDIT_ITEM_ENTITY = "AuditItem";

    public UpgradeTask_Build6256() {
        super(false);
    }

    @Override
    public String getShortDescription() {
        return "Drop unnecessary unique index on AuditItem entity";
    }

    @Override
    public String getBuildNumber() {
        return "6256";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        GenericDelegator delegator = this.getDelegator();
        String helperName = delegator.getEntityHelper(AUDIT_ITEM_ENTITY).getHelperName();
        ModelEntity entity = delegator.getModelEntity(AUDIT_ITEM_ENTITY);
        String tableName = entity.getPlainTableName();
        DatabaseUtil dbUtil = new DatabaseUtil(helperName);
        ArrayList messages = Lists.newArrayList();
        Map indexes = dbUtil.getIndexInfo((Set)ImmutableSet.of((Object)tableName), (Collection)messages, true);
        String oldIndexName = "idx_audit_item_log_id";
        if (indexes != null && indexes.get(tableName) != null) {
            for (String index : (Set)indexes.get(tableName)) {
                if (!"idx_audit_item_log_id".equalsIgnoreCase(index)) continue;
                this.dropIndex(tableName, "idx_audit_item_log_id");
                break;
            }
        }
    }
}

