/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.EntityListConsumer;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import java.util.HashSet;
import java.util.Set;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build6255
extends AbstractUpgradeTask {
    private static final String DRAFT_WORKFLOW_SCHEME_ENTITY = "DraftWorkflowSchemeEntity";
    private final EntityEngine entityEngine;
    private EntityListConsumer<GenericValue, Set<Long>> idCollector = new EntityListConsumer<GenericValue, Set<Long>>(){
        private Set<Long> result = new HashSet<Long>();

        @Override
        public void consume(GenericValue entity) {
            this.result.add(entity.getLong("id"));
        }

        @Override
        public Set<Long> result() {
            return this.result;
        }
    };

    public UpgradeTask_Build6255(EntityEngine entityEngine) {
        super(false);
        this.entityEngine = entityEngine;
    }

    @Override
    public String getBuildNumber() {
        return "6255";
    }

    @Override
    public String getShortDescription() {
        return "Removes orphaned mappings generated by upgrade task 6123";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        Set<Long> draftSchemeIds = Select.columns("id").from("DraftWorkflowScheme").runWith(this.entityEngine).consumeWith(this.idCollector);
        for (GenericValue entity : Select.columns("id", "scheme").from(DRAFT_WORKFLOW_SCHEME_ENTITY).runWith(this.entityEngine).asList()) {
            long entityId = entity.getLong("id");
            long schemeId = entity.getLong("scheme");
            if (draftSchemeIds.contains(schemeId)) continue;
            this.entityEngine.delete(Delete.from(DRAFT_WORKFLOW_SCHEME_ENTITY).whereIdEquals(entityId));
        }
    }
}

