/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build6253
extends AbstractUpgradeTask {
    private final OfBizDelegator ofBizDelegator;
    private static final String SCHEME_PERMISSIONS_TABLE = "SchemePermissions";
    private static final String SCHEME_PERMISSIONS_SCHEME_COLUMN = "scheme";
    private static final String SCHEME_PERMISSIONS_PERMISSION_COLUMN = "permission";
    private static final String SCHEME_PERMISSIONS_GROUP_COLUMN = "parameter";
    private static final String SCHEME_PERMISSIONS_TYPE_COLUMN = "type";
    private static final String TYPE_EXPECTED_VALUE = "group";
    private static final String GLOBAL_PERMISSION_ENTRY_TABLE = "GlobalPermissionEntry";
    private static final String GLOBAL_PERMISSION_PERMISSION_COLUMN = "permission";
    private static final String GLOBAL_PERMISSION_GROUP_COLUMN = "group_id";
    private static Map<Long, String> GLOBAL_PERMISSION_ID_TRANSLATION;

    public UpgradeTask_Build6253(OfBizDelegator ofBizDelegator) {
        super(false);
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public String getBuildNumber() {
        return "6253";
    }

    @Override
    public String getShortDescription() {
        return "Migrates global permission entries out of SchemePermissions and into it's own table";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        List oldGlobalPermissions = this.ofBizDelegator.findByCondition(SCHEME_PERMISSIONS_TABLE, (EntityCondition)new EntityExpr(SCHEME_PERMISSIONS_SCHEME_COLUMN, EntityOperator.EQUALS, null), null);
        for (GenericValue gv : oldGlobalPermissions) {
            Long id = gv.getLong("permission");
            String group = gv.getString(SCHEME_PERMISSIONS_GROUP_COLUMN);
            String type = gv.getString(SCHEME_PERMISSIONS_TYPE_COLUMN);
            if (!TYPE_EXPECTED_VALUE.equals(type) || !GLOBAL_PERMISSION_ID_TRANSLATION.containsKey(id)) continue;
            String permissionKey = GLOBAL_PERMISSION_ID_TRANSLATION.get(id);
            this.migrateValue(permissionKey, StringUtils.defaultIfBlank((String)group, null));
        }
    }

    private void migrateValue(String permissionKey, String group) {
        HashMap conditions = Maps.newHashMap();
        conditions.put("permission", permissionKey);
        conditions.put(GLOBAL_PERMISSION_GROUP_COLUMN, group);
        List existingPermissions = this.ofBizDelegator.findByAnd(GLOBAL_PERMISSION_ENTRY_TABLE, (Map)conditions);
        if (existingPermissions.isEmpty()) {
            this.ofBizDelegator.createValue(GLOBAL_PERMISSION_ENTRY_TABLE, (Map)FieldMap.build((String)"permission", (Object)permissionKey).add(GLOBAL_PERMISSION_GROUP_COLUMN, (Object)group));
        }
    }

    static {
        HashMap map = Maps.newHashMap();
        map.put(0L, "ADMINISTER");
        map.put(1L, "USE");
        map.put(44L, "SYSTEM_ADMIN");
        map.put(22L, "CREATE_SHARED_OBJECTS");
        map.put(24L, "MANAGE_GROUP_FILTER_SUBSCRIPTIONS");
        map.put(33L, "BULK_CHANGE");
        map.put(27L, "USER_PICKER");
        GLOBAL_PERMISSION_ID_TRANSLATION = Collections.unmodifiableMap(map);
    }
}

