/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.workflow.CachingDraftWorkflowStore;
import com.atlassian.jira.workflow.CachingWorkflowDescriptorStore;
import com.atlassian.jira.workflow.DraftWorkflowStore;
import com.atlassian.jira.workflow.WorkflowDescriptorStore;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.ResultDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build6210
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build6210.class);
    private static final String META_UPDATE_AUTHOR_NAME = "jira.update.author.name";
    private static final String META_UPDATE_AUTHOR_KEY = "jira.update.author.key";
    public static final String DESCRIPTOR_ENTITY_FIELD = "descriptor";
    public static final String DRAFT_WORKFLOW_ENTITY_NAME = "DraftWorkflow";
    public static final String WORKFLOW_ENTITY_NAME = "Workflow";
    private final EntityEngine entityEngine;

    public UpgradeTask_Build6210(EntityEngine entityEngine) {
        super(false);
        this.entityEngine = entityEngine;
    }

    @Override
    public String getShortDescription() {
        return "Converting workflows and draft workflows to keep keys instead of usernames";
    }

    @Override
    public String getBuildNumber() {
        return "6210";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        this.convertJiraWorkflows();
        this.convertJiraDraftWorkflows();
        WorkflowDescriptorStore workflowDescriptorStore = (WorkflowDescriptorStore)ComponentAccessor.getComponent(WorkflowDescriptorStore.class);
        if (workflowDescriptorStore instanceof CachingWorkflowDescriptorStore) {
            log.info((Object)"Cleaning CachingWorkflowDescriptorStore cache");
            ((CachingWorkflowDescriptorStore)workflowDescriptorStore).onClearCache(null);
        } else {
            log.info((Object)"Used WorkflowDescriptorStore is not a known caching type. Cannot rebuild workflow's cache");
        }
        DraftWorkflowStore draftWorkflowStore = (DraftWorkflowStore)ComponentAccessor.getComponent(DraftWorkflowStore.class);
        if (draftWorkflowStore instanceof CachingDraftWorkflowStore) {
            log.info((Object)"Cleaning CachingWorkflowDescriptorStore cache");
            ((CachingDraftWorkflowStore)draftWorkflowStore).onClearCache(null);
        } else {
            log.info((Object)"Used WorkflowDescriptorStore is not a known caching type. Cannot rebuild workflow's cache");
        }
    }

    private void convertJiraDraftWorkflows() {
        List<GenericValue> drafts = this.entityEngine.run(Select.columns("id", DESCRIPTOR_ENTITY_FIELD).from(DRAFT_WORKFLOW_ENTITY_NAME)).asList();
        for (GenericValue draft : drafts) {
            this.updateWorkflow(draft, DRAFT_WORKFLOW_ENTITY_NAME);
        }
    }

    private void convertJiraWorkflows() {
        List<GenericValue> workflows = this.entityEngine.run(Select.columns("id", DESCRIPTOR_ENTITY_FIELD).from(WORKFLOW_ENTITY_NAME)).asList();
        for (GenericValue workflow : workflows) {
            this.updateWorkflow(workflow, WORKFLOW_ENTITY_NAME);
        }
    }

    private void updateWorkflow(GenericValue workflow, String entityName) {
        WorkflowDescriptor descriptor;
        try {
            descriptor = WorkflowUtil.convertXMLtoWorkflowDescriptor((String)workflow.getString(DESCRIPTOR_ENTITY_FIELD));
        }
        catch (FactoryException fe) {
            log.error((Object)("Unable to update username references in corrupted workflow: " + (Object)((Object)fe)));
            return;
        }
        UpgradeTask_Build6210.convertAuthorUsernameToUserKey(descriptor);
        this.convertAssigneeFieldValueToUserKey(descriptor);
        String postConversionDescriptor = WorkflowUtil.convertDescriptorToXML((WorkflowDescriptor)descriptor);
        Update.WhereContext query = Update.into(entityName).set(DESCRIPTOR_ENTITY_FIELD, postConversionDescriptor).whereIdEquals(workflow.getLong("id"));
        this.entityEngine.execute(query);
    }

    private static void convertAuthorUsernameToUserKey(WorkflowDescriptor descriptor) {
        Map meta = descriptor.getMetaAttributes();
        String username = (String)meta.remove(META_UPDATE_AUTHOR_NAME);
        if (username != null) {
            String userKey = IdentifierUtils.toLowerCase((String)username);
            meta.put(META_UPDATE_AUTHOR_KEY, userKey != null ? userKey : username);
        }
    }

    private void convertAssigneeFieldValueToUserKey(WorkflowDescriptor descriptor) {
        List<FunctionDescriptor> postFunctions = this.getAllWorkflowPostFunctions(descriptor);
        for (FunctionDescriptor postFunction : postFunctions) {
            if (!UpgradeTask_Build6210.setsAssigneeField(postFunction)) continue;
            Map postFunctionArgs = postFunction.getArgs();
            String newAssigneeValue = UpgradeTask_Build6210.convertUsernameToUserKey((String)postFunctionArgs.get("field.value"));
            postFunctionArgs.put("field.value", newAssigneeValue);
        }
    }

    List<FunctionDescriptor> getAllWorkflowPostFunctions(WorkflowDescriptor descriptor) {
        ArrayList actions = Lists.newArrayList();
        ArrayList postFunctions = Lists.newArrayList();
        actions.addAll(descriptor.getInitialActions());
        actions.addAll(descriptor.getGlobalActions());
        actions.addAll(descriptor.getCommonActions().values());
        List steps = descriptor.getSteps();
        for (StepDescriptor step : steps) {
            postFunctions.addAll(step.getPostFunctions());
            actions.addAll(step.getActions());
        }
        HashMap uniqueActions = Maps.newHashMap();
        for (ActionDescriptor action : actions) {
            if (action == null) continue;
            uniqueActions.put(action.getId(), action);
        }
        for (ActionDescriptor action : uniqueActions.values()) {
            for (ResultDescriptor result : action.getConditionalResults()) {
                postFunctions.addAll(result.getPostFunctions());
            }
            postFunctions.addAll(action.getUnconditionalResult().getPostFunctions());
            postFunctions.addAll(action.getPostFunctions());
        }
        return postFunctions;
    }

    static boolean setsAssigneeField(FunctionDescriptor postFunction) {
        return postFunction.getType().equals("class") && postFunction.getArgs().containsKey("field.name") && postFunction.getArgs().get("field.name").equals("assignee");
    }

    static String convertUsernameToUserKey(String possiblyAUsername) {
        if (StringUtils.isBlank((CharSequence)possiblyAUsername)) {
            return "";
        }
        if (UpgradeTask_Build6210.isRenamedUserKey(possiblyAUsername)) {
            return possiblyAUsername;
        }
        return IdentifierUtils.toLowerCase((String)possiblyAUsername);
    }

    static boolean isRenamedUserKey(String input) {
        return Pattern.matches("^ID\\d+$", input);
    }
}

