/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import java.sql.Connection;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build6208
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build6208.class);
    private final EntityEngine entityEngine;

    public UpgradeTask_Build6208(EntityEngine entityEngine) {
        super(true);
        this.entityEngine = entityEngine;
    }

    @Override
    public String getBuildNumber() {
        return "6208";
    }

    @Override
    public String getShortDescription() {
        return "Populates the issue creator field";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        Connection connection = null;
        try {
            connection = this.getDatabaseConnection();
            this.copyReporterToCreator(connection);
            this.fixUpChangedReporters();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyReporterToCreator(Connection connection) throws Exception {
        Statement updateStmt = null;
        try {
            String updateSql = "UPDATE " + this.convertToSchemaTableName("jiraissue") + " SET creator = reporter";
            updateStmt = connection.prepareStatement(updateSql);
            int updatedCount = updateStmt.executeUpdate();
            log.info((Object)String.format("Updated %d issues.", updatedCount));
        }
        finally {
            if (updateStmt != null) {
                updateStmt.close();
            }
        }
    }

    private void fixUpChangedReporters() {
        List reporterChanges = Select.from("ChangeGroupChangeItemView").whereEqual("field", "reporter").orderBy("changegroupid desc").runWith(this.entityEngine).asList();
        for (GenericValue change : reporterChanges) {
            long issueId = change.getLong("issue");
            String reporter = change.getString("oldvalue");
            this.entityEngine.execute(Update.into("Issue").set("creator", reporter).whereEqual("id", issueId));
        }
    }
}

