/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build6207
extends AbstractUpgradeTask {
    protected static final String[] ISSUE_CONSTANT_ENTITIES = new String[]{"IssueType", "Resolution", "Priority", "Status"};
    private static final Logger logger = Logger.getLogger(UpgradeTask_Build6207.class);
    private final OfBizDelegator ofBizDelegator;

    public UpgradeTask_Build6207(OfBizDelegator ofBizDelegator) {
        super(false);
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public String getBuildNumber() {
        return "6207";
    }

    @Override
    public String getShortDescription() {
        return "Set base sequence number for issue constants.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        for (String entityName : ISSUE_CONSTANT_ENTITIES) {
            logger.info((Object)("Updating sequence id for issue constant " + entityName));
            Long initialId = this.getInitialId(entityName);
            logger.debug((Object)("Setting sequence id for issue constant " + entityName + " to initial value " + initialId));
            this.setNextId(entityName, initialId);
        }
    }

    private Long getInitialId(String entityName) {
        long maxID = 10000L;
        for (GenericValue entity : this.ofBizDelegator.findAll(entityName)) {
            try {
                long entityId = Long.parseLong(entity.getString("id"));
                if (entityId < maxID) continue;
                maxID = entityId + 1L;
            }
            catch (NumberFormatException nfe) {}
        }
        return maxID;
    }

    private void setNextId(String entityName, Long nextId) {
        this.ofBizDelegator.getDelegatorInterface().getNextSeqId(entityName);
        GenericValue sequenceItem = EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("SequenceValueItem", (Map)ImmutableMap.of((Object)"seqName", (Object)entityName)));
        sequenceItem.set("seqId", (Object)nextId);
        this.ofBizDelegator.store(sequenceItem);
        this.ofBizDelegator.refreshSequencer();
    }
}

