/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.StatusCategoryManager;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.issue.status.category.StatusCategoryMapper;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build6206
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build6206.class);
    private static final String ENTITY_STATUS = "Status";
    private static final String STATUS_CATEGORY_COLUMN = "statuscategory";
    private final StatusCategoryManager statusCategoryManager;
    private final WorkflowManager workflowManager;
    private final ConstantsManager constantsManager;
    private final StatusCategoryMapper mapper;

    public UpgradeTask_Build6206(WorkflowManager workflowManager, StatusCategoryManager statusCategoryManager, ConstantsManager constantsManager) {
        super(false);
        this.workflowManager = workflowManager;
        this.statusCategoryManager = statusCategoryManager;
        this.constantsManager = constantsManager;
        this.mapper = new StatusCategoryMapper(statusCategoryManager);
    }

    @Override
    public String getBuildNumber() {
        return "6206";
    }

    @Override
    public String getShortDescription() {
        return "Sets status categories for all statuses in a system. Explicitly sets Atlassian defined statuses, then makes a best guess at user-defined ones.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        StatusCategory defaultStatusCategory = this.statusCategoryManager.getDefaultStatusCategory();
        StatusCategory newCategory = this.statusCategoryManager.getStatusCategoryByKey("new");
        StatusCategory completedCategory = this.statusCategoryManager.getStatusCategoryByKey("done");
        StatusCategory inProgressCategory = this.statusCategoryManager.getStatusCategoryByKey("indeterminate");
        log.info((Object)"Setting default status categories...");
        this.setStatusToCategory("1", newCategory.getId());
        this.setStatusToCategory("4", newCategory.getId());
        this.setStatusToCategory("3", inProgressCategory.getId());
        this.setStatusToCategory("5", completedCategory.getId());
        this.setStatusToCategory("6", completedCategory.getId());
        log.info((Object)"Finding statuses with no assigned status category semantics...");
        ArrayList statusesWithUndefinedSemantics = Lists.newArrayList();
        statusesWithUndefinedSemantics.addAll(UpgradeTask_Build6206.getEntityEngine().run(Select.from(ENTITY_STATUS).whereNull(STATUS_CATEGORY_COLUMN)).asList());
        statusesWithUndefinedSemantics.addAll(UpgradeTask_Build6206.getEntityEngine().run(Select.from(ENTITY_STATUS).whereEqual(STATUS_CATEGORY_COLUMN, defaultStatusCategory.getId())).asList());
        List statusIdsWithUndefinedSemantics = Lists.transform((List)statusesWithUndefinedSemantics, (Function)new Function<GenericValue, String>(){

            public String apply(@Nullable GenericValue input) {
                return null == input ? null : input.getString("id");
            }
        });
        ArrayListMultimap statusIdsToCategories = ArrayListMultimap.create();
        log.info((Object)"Parsing workflows...");
        for (JiraWorkflow workflow : this.workflowManager.getWorkflows()) {
            Map<String, StatusCategory> results = this.mapper.mapCategoriesToStatuses(workflow);
            log.debug((Object)String.format("Found %d statuses for workflow %s", results.size(), workflow.getName()));
            for (String statusId : results.keySet()) {
                if (statusIdsWithUndefinedSemantics.contains(statusId)) {
                    StatusCategory category = results.get(statusId);
                    statusIdsToCategories.put((Object)statusId, (Object)category.getId());
                    log.debug((Object)String.format("Status '%s' could be assigned to the '%s' category", statusId, category.getKey()));
                    continue;
                }
                log.debug((Object)String.format("Status '%s' has predefined semantics, skipping", statusId));
            }
        }
        log.debug((Object)String.format("Found %d statuses with %d potential values", statusIdsToCategories.size(), statusIdsToCategories.values().size()));
        log.info((Object)String.format("Assigning categories to %d statuses...", statusIdsToCategories.size()));
        for (String statusId : statusIdsToCategories.keySet()) {
            Long categoryId = statusIdsToCategories.containsEntry((Object)statusId, (Object)completedCategory.getId()) ? completedCategory.getId() : (statusIdsToCategories.containsEntry((Object)statusId, (Object)newCategory.getId()) ? newCategory.getId() : inProgressCategory.getId());
            this.setStatusToCategory(statusId, categoryId);
        }
        this.constantsManager.invalidateAll();
    }

    private void setStatusToCategory(String statusId, Long newCategoryId) {
        Update.into(ENTITY_STATUS).set(STATUS_CATEGORY_COLUMN, newCategoryId).whereEqual("id", statusId).execute(UpgradeTask_Build6206.getEntityEngine());
    }
}

