/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.TransactionSupport;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build6154
extends AbstractUpgradeTask {
    private final TransactionSupport transactionSupport;
    private final OfBizDelegator ofBizDelegator;
    private final EntityEngine entityEngine;
    private final ApplicationProperties applicationProperties;

    public UpgradeTask_Build6154(TransactionSupport transactionSupport, OfBizDelegator ofBizDelegator, EntityEngine entityEngine, ApplicationProperties applicationProperties) {
        super(false);
        this.transactionSupport = transactionSupport;
        this.ofBizDelegator = ofBizDelegator;
        this.entityEngine = entityEngine;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public String getBuildNumber() {
        return "6154";
    }

    @Override
    public String getShortDescription() {
        return "Removing JIRA property jira.clone.link.legacy.direction";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        Transaction transaction = this.transactionSupport.begin();
        try {
            GenericValue flag = this.entityEngine.run(Select.from("OSPropertyEntry").whereEqual("propertyKey", "jira.clone.link.legacy.direction")).singleValue();
            if (flag != null) {
                this.ofBizDelegator.removeValue(flag);
                GenericValue value = this.entityEngine.run(Select.from("OSPropertyNumber").whereEqual("id", flag.getLong("id"))).singleValue();
                if (value != null) {
                    this.ofBizDelegator.removeValue(value);
                }
            }
            transaction.commit();
            this.applicationProperties.refresh();
        }
        finally {
            transaction.finallyRollbackIfNotCommitted();
        }
    }
}

