/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.jira.entity.GenericValueFunctions;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.upgrade.tasks.UpgradeTask_Build602;
import com.atlassian.jira.util.Visitor;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build6151
extends AbstractUpgradeTask {
    static final String ENTITY = "User";
    static final String EXTERNAL_ID = "externalId";
    static final String USER_NAME = "userName";
    static final String DIRECTORY_ID = "directoryId";

    public UpgradeTask_Build6151() {
        super(false);
    }

    @Override
    public String getBuildNumber() {
        return "6151";
    }

    @Override
    public String getShortDescription() {
        return "Set unique id for users in internal directory";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        List internalDirectories = Select.columns("id").from("Directory").whereCondition((EntityCondition)new EntityExpr("type", EntityOperator.EQUALS, (Object)DirectoryType.INTERNAL.toString())).runWith(UpgradeTask_Build6151.getEntityEngine()).asList();
        Collection internalDirectoryIds = Collections2.transform(internalDirectories, (Function)GenericValueFunctions.getLong("id"));
        Select.from(ENTITY).whereCondition((EntityCondition)new EntityExpr(DIRECTORY_ID, EntityOperator.IN, (Object)internalDirectoryIds)).andEqual(EXTERNAL_ID, (String)null).runWith(UpgradeTask_Build6151.getEntityEngine()).visitWith(new Visitor<GenericValue>(){

            public void visit(GenericValue element) {
                try {
                    element.set(UpgradeTask_Build6151.EXTERNAL_ID, (Object)InternalDirectory.generateUniqueIdentifier());
                    element.store();
                }
                catch (GenericEntityException e) {
                    throw new RuntimeException(String.format("Unable to store User %s (directory %s)", element.getString(UpgradeTask_Build6151.USER_NAME), element.getLong(UpgradeTask_Build6151.DIRECTORY_ID)), e);
                }
            }
        });
        UpgradeTask_Build602.flushUserCaches();
    }

    static class Directory {
        static final String ENTITY = "Directory";
        static final String DIRECTORY_ID = "id";
        static final String TYPE = "type";

        Directory() {
        }
    }
}

