/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.impl.CascadingSelectCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import java.util.List;
import org.apache.log4j.Logger;

public class UpgradeTask_Build6142
extends AbstractUpgradeTask {
    private final Logger log = Logger.getLogger(this.getClass());
    private final CustomFieldManager customFieldManager;

    public UpgradeTask_Build6142(CustomFieldManager customFieldManager) {
        super(false);
        this.customFieldManager = customFieldManager;
    }

    @Override
    public String getBuildNumber() {
        return "6142";
    }

    @Override
    public String getShortDescription() {
        return "Run a reindex if the instance has Cascading Select fields since their values will now be added to the Lucene index.";
    }

    @Override
    public boolean isReindexRequired() {
        List customFields = this.customFieldManager.getCustomFieldObjects();
        for (CustomField customField : customFields) {
            if (!(customField.getCustomFieldType() instanceof CascadingSelectCFType)) continue;
            this.log.info((Object)"A Reindex will be performed because at least 1 Cascade Select Custom Field is present");
            return true;
        }
        this.log.info((Object)"No reindex will be performed.");
        return false;
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
    }
}

