/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.user.ApplicationUserEntity;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.user.util.UserKeyStoreImpl;
import java.util.HashSet;
import java.util.List;

public class UpgradeTask_Build6040
extends AbstractUpgradeTask {
    private final EntityEngine entityEngine;

    public UpgradeTask_Build6040(EntityEngine entityEngine) {
        super(false);
        this.entityEngine = entityEngine;
    }

    @Override
    public String getBuildNumber() {
        return "6040";
    }

    @Override
    public String getShortDescription() {
        return "Map existing usernames to userkeys for rename user.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        Select.SelectColumnsFromContext<String> selectQuery = Select.distinctString("lowerUserName").from("User");
        List<String> lowerUsernames = this.entityEngine.run(selectQuery).asList();
        List mappedUsernameList = Select.stringColumn("lowerUserName").from(Entity.APPLICATION_USER).runWith(this.entityEngine).asList();
        HashSet mappedUsernames = new HashSet(mappedUsernameList);
        for (String lowerUsername : lowerUsernames) {
            if (mappedUsernames.contains(lowerUsername)) continue;
            this.mapUsername(lowerUsername);
        }
        UserKeyStoreImpl userKeyStore = (UserKeyStoreImpl)ComponentAccessor.getComponent(UserKeyStore.class);
        userKeyStore.onClearCache(null);
    }

    private void mapUsername(String lowerUsername) {
        this.entityEngine.createValue(Entity.APPLICATION_USER, new ApplicationUserEntity(null, lowerUsername, lowerUsername));
    }
}

